// ReportPrint.cpp: implementation of the ReportPrint class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MyPrint.h"
#include "ReportPrint.h"
#include <winspool.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

ReportPrint::ReportPrint()
{
	m_printPoint[0].x = 20;
	m_printPoint[0].y = 20;
	m_printPoint[1].x = 20;
	m_printPoint[1].y = 200;
}

ReportPrint::~ReportPrint()
{

}
//ôӡ Ĭ 15
void ReportPrint::SetTextFont(char* height,char* faceName)
{

	m_csHeight = height;
	m_csFaceName = faceName;
}

//ôӡֽŵĴС 
void ReportPrint::SetPaperSize(CSize paperSize)
{
	m_paperSize = paperSize;
}
//ôӡֽŵĴС  
void ReportPrint::SetPaperSize(int x, int y)
{
	m_paperSize.cx = x;
	m_paperSize.cy = y;
}
//ôӡ ͬʱӡ
void ReportPrint::SetPrintInfo(PRINTINFO printInfo[], int size)
{
	m_pPrintInfo = printInfo;
	m_nMaxPage = size;
}
//ӡ
void ReportPrint::Print(BOOL bDirect)
{
	DWORD dwflags=PD_ALLPAGES | PD_NOPAGENUMS | PD_USEDEVMODECOPIES | PD_SELECTION | PD_HIDEPRINTTOFILE; 	
	CPrintDialog dlg(0);//(bDirect,dwflags,NULL);
//	dlg.GetDefaults();

	

//	if (dev = dlg.GetDevMode());
	if(dlg.DoModal()==IDOK)
	{

		CDC dc;	

		//ӡģʽϢ
		LPDEVMODE dev = dlg.GetDevMode();

	
		dev->dmPaperSize = DMPAPER_USER;
		dev->dmPaperLength = m_paperSize.cy * 10;
		dev->dmPaperWidth = m_paperSize.cx * 10;
		dev->dmFields = DM_PAPERSIZE | DM_PAPERWIDTH | DM_PAPERLENGTH | dev->dmFields;
		dev->dmFields = dev->dmFields | DMBIN_MANUAL;
		dev->dmDefaultSource = DMBIN_MANUAL;

		strcpy((char*)dev->dmFormName,"Զ");
		dc.Attach(dlg.CreatePrinterDC());		//ӡDC
/*
		DOCINFO   di; 
		memset(  &di,   0,   sizeof(DOCINFO)   ); 
		di.cbSize   =   sizeof(DOCINFO);   
		di.lpszDocName   =   "Printing   Test ";   
		di.lpszOutput   =   (LPTSTR)   NULL;   
		di.lpszDatatype = (LPTSTR) NULL;
		di.fwType   =   0; 
*/
		dc.StartDoc("print");

		CFont font;
		font.CreatePointFont(atoi(m_csHeight)*10,m_csFaceName,&dc);

		dc.SelectObject(&font);			//û
		
		for (int i=0;i<m_nMaxPage;i++)
		{
			dc.StartPage();
			for (int j=0;j<POINT_COUNT;j++)
			{
				dc.TextOut(m_printPoint[j].x*10,m_printPoint[j].y*10,m_pPrintInfo[i].text[j]);
			}
			dc.EndPage();
		}

		dc.EndDoc();
		font.DeleteObject();
		dc.DeleteDC();
	}

	
}
//ӡԤ
void ReportPrint::PrintPreview()
{
	CDlgReportPrintPreview dlg(m_csHeight,m_csHeight,m_paperSize,m_pPrintInfo,m_nMaxPage,m_printPoint,POINT_COUNT,this);
	dlg.m_bEditMode = m_bEditMode;
	dlg.DoModal();
}



/////////////////////////////////////////////////////////////////////////////
// CDlgReportPrintPreview dialog


CDlgReportPrintPreview::CDlgReportPrintPreview(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgReportPrintPreview::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgReportPrintPreview)
	m_nCurPage = 0;
	m_nPosX = 0;
	m_nPosY = 0;
	//}}AFX_DATA_INIT
}

CDlgReportPrintPreview::CDlgReportPrintPreview(CString& csHeight,CString& csFaceName, CSize paperSize, PRINTINFO printInfo[], int nMaxPage, CPoint* pPrintPoint, int nPrintCount,ReportPrint* parent )
	: CDialog(CDlgReportPrintPreview::IDD, NULL)
{
	//ʼ
	m_csHeight = csHeight;
	m_csFaceName = csFaceName;
	//ʼֽŴС
	m_paperSize = paperSize;
	//ʼӡϢ
	m_pPrintInfo = printInfo;
	//ʼӡҳ
	m_nMaxPage = nMaxPage;
	//ʼӡ
	m_pPrintPoint = pPrintPoint;
	//ʼӡ
	m_nPrintCount = nPrintCount;
	//ָ
	m_pParent = parent;

	m_previewRect.bottom = m_previewRect.top = m_previewRect.left = m_previewRect.right =0;
	m_nCurPage=1;

	m_bEditMode = FALSE;


}
void CDlgReportPrintPreview::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgReportPrintPreview)
	DDX_Control(pDX, IDC_COMBO_NODE, m_ctrlNodes);
	DDX_Text(pDX, IDC_EDIT_CUR_PAGE, m_nCurPage);
	DDX_Text(pDX, IDC_EDIT_X, m_nPosX);
	DDX_Text(pDX, IDC_EDIT_Y, m_nPosY);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgReportPrintPreview, CDialog)
	//{{AFX_MSG_MAP(CDlgReportPrintPreview)
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_BN_PRE, OnBnPre)
	ON_BN_CLICKED(IDC_BN_NEXT, OnBnNext)
	ON_BN_CLICKED(IDC_BN_SET_POS, OnBnSetPos)
	ON_CBN_SELCHANGE(IDC_COMBO_NODE, OnSelchangeComboNode)
	ON_EN_CHANGE(IDC_EDIT_Y, OnChangeEditY)
	ON_EN_CHANGE(IDC_EDIT_X, OnChangeEditX)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgReportPrintPreview message handlers

BOOL CDlgReportPrintPreview::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	CString str;
	int i=0;
	for (;i<POINT_COUNT;i++)
	{

		str.Format("   [%d] ",i);
		m_ctrlNodes.AddString(str);
	}
	m_ctrlNodes.SelectString(i,str);

	m_ctrlNodes.SetCurSel(0);
	m_nPosX = m_pPrintPoint[0].x;
	m_nPosY = m_pPrintPoint[0].y;
	CString csPosX;
	csPosX.Format("%d",m_nPosX);
	CString csPosY;
	csPosY.Format("%d",m_nPosY);
	SetDlgItemText(IDC_EDIT_X,csPosX);
	SetDlgItemText(IDC_EDIT_Y,csPosY);
	UpdateData(TRUE);


	if (m_bEditMode == FALSE)
	{
		GetDlgItem(IDC_STATIC_NODE)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_STATIC_POS)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_BN_SET_POS)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_COMBO_NODE)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_EDIT_X)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_EDIT_Y)->ShowWindow(SW_HIDE);
	}


	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDlgReportPrintPreview::OnPaint() 
{

//	CPaintDC pDC(this->GetDlgItem(IDD_DLG_PRINT_PREVIEW));
	CDialog::OnPaint();

	CDC* pDC;
	pDC = GetDC();
	GetClientRect(&m_previewRect);//ÿͻС  

	m_previewRect.left +=40;
	m_previewRect.right-=40;
	m_previewRect.top +=70;
	m_previewRect.bottom -=40;

	m_nRato=float(m_previewRect.right-m_previewRect.left)/m_paperSize.cx;			//ԤڵĿȳֽŵĿ  õԤű
	m_previewRect.bottom =m_previewRect.top+int(m_paperSize.cy*m_nRato);			//űԤֽŵĳ ֤Ԥֽŵĸ߿
	DrawPrintPreview(pDC,&m_previewRect);
}

void CDlgReportPrintPreview::DrawPrintPreview(CDC *pDC, CRect *previewRect)
{
	CFont font,*pOldFont;
	CPen pen,*pOldPen;


	GetDlgItem(IDC_STATIC_MAP)->ShowWindow(SW_HIDE);

	pen.CreatePen(PS_SOLID,2,RGB(255,0,0));		//

	font.CreatePointFont(int(atoi(m_csHeight)*10/m_nRato),m_csFaceName,pDC);

	pOldFont=pDC->SelectObject(&font);			//ѡ
	pOldPen=pDC->SelectObject(&pen);			//ѡ
	pDC->SetBkMode(OPAQUE);						//λͼģʽΪ͸ 
	pDC->SetBkColor(RGB(255,255,255));			//λͼɫΪɫ 
	
	//λͼ
	pDC->FillSolidRect(previewRect->left-1,previewRect->top-1,previewRect->Width()+2,previewRect->Height()+2,RGB(25,25,25)); 
	pDC->FillSolidRect(previewRect->left,previewRect->top,previewRect->Width(),previewRect->Height(),RGB(255,255,255)); 

	//ʾɫ  
	pDC->SetTextColor(RGB(0,0,0));

	//ӡԤ
	for (int j=0;j<POINT_COUNT;j++)
	{
		CString str;
		str.Format("%s[%d]",m_pPrintInfo[m_nCurPage-1].text[j],j+1);
		pDC->TextOut(previewRect->left+m_pPrintPoint[j].x,previewRect->top+m_pPrintPoint[j].y,str);
	}

	font.DeleteObject();
	pen.DeleteObject ();
}

void CDlgReportPrintPreview::OnBnPre() 
{
	if (m_nCurPage == 1)
	{
		AfxMessageBox("Ѿǵһҳ");
	}
	else
	{
		m_nCurPage--;
		UpdateData(FALSE);
		Invalidate(FALSE);
	}

}

void CDlgReportPrintPreview::OnBnNext() 
{
	if (m_nCurPage == m_nMaxPage)
	{
		AfxMessageBox("Ѿһҳ");
	}
	else
	{
		m_nCurPage++;
		UpdateData(FALSE);
		Invalidate(FALSE);
	}
}

void CDlgReportPrintPreview::OnOK() 
{
	m_pParent->Print(FALSE);
	
//	CDialog::OnOK();
}


void CDlgReportPrintPreview::OnBnSetPos() 
{
	UpdateData(FALSE);
	int index = m_ctrlNodes.GetCurSel();
	((m_pPrintPoint[index])).x = (GetDlgItemInt(IDC_EDIT_X));
	((m_pPrintPoint[index])).y = (GetDlgItemInt(IDC_EDIT_Y));
	int i = m_pPrintPoint[m_ctrlNodes.GetCurSel()].x;
	int j = m_pPrintPoint[m_ctrlNodes.GetCurSel()].y;
	UpdateData(TRUE);
	Invalidate(FALSE);
}

void CDlgReportPrintPreview::OnSelchangeComboNode() 
{
	int index = m_ctrlNodes.GetCurSel();
	if (index == -1)
	{
		index =0;
		m_ctrlNodes.SetCurSel(0);
	}
	m_nPosX = m_pPrintPoint[index].x;
	m_nPosY = m_pPrintPoint[index].y;
	CString csPosX;
	csPosX.Format("%d",m_nPosX);
	CString csPosY;
	csPosY.Format("%d",m_nPosY);
	SetDlgItemText(IDC_EDIT_X,csPosX);
	SetDlgItemText(IDC_EDIT_Y,csPosY);
	UpdateData(TRUE);
}	

void CDlgReportPrintPreview::OnChangeEditX() 
{
	m_nPosX = GetDlgItemInt(IDC_EDIT_X);
}

void CDlgReportPrintPreview::OnChangeEditY() 
{
	m_nPosY = GetDlgItemInt(IDC_EDIT_Y);
}


