/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;

public class Scope {
    private int _$3;
    public Scope next;
    public Symbol owner;
    public Entry[] table;
    int hashMask;
    public Entry elems;
    public int nelems = 0;
    private static final Entry _$2 = new Entry(null, null, null, null);
    private static final int _$1 = 128;
    public static final Scope emptyScope = new Scope(null, null, new Entry[0]);

    Scope(Scope scope, Symbol symbol, Entry[] entryArray) {
        this.next = scope;
        assert (emptyScope == null || symbol != null);
        this.owner = symbol;
        this.table = entryArray;
        this.hashMask = entryArray.length - 1;
        this.elems = null;
        this.nelems = 0;
        this._$3 = 0;
    }

    public Scope(Symbol symbol) {
        this(null, symbol, new Entry[128]);
        for (int i = 0; i < 128; ++i) {
            this.table[i] = _$2;
        }
    }

    public Scope dup() {
        Scope scope = new Scope(this, this.owner, this.table);
        ++this._$3;
        return scope;
    }

    public Scope dup(Symbol symbol) {
        Scope scope = new Scope(this, symbol, this.table);
        ++this._$3;
        return scope;
    }

    public Scope dupUnshared() {
        return new Scope(this, this.owner, (Entry[])this.table.clone());
    }

    public Scope leave() {
        assert (this._$3 == 0);
        if (this.table != this.next.table) {
            return this.next;
        }
        while (this.elems != null) {
            int n = this.elems.sym.name.index & this.hashMask;
            Entry entry = this.table[n];
            assert (entry == this.elems) : this.elems.sym;
            this.table[n] = this.elems._$1;
            this.elems = this.elems.sibling;
        }
        assert (this.next._$3 > 0);
        --this.next._$3;
        return this.next;
    }

    private void _$1() {
        int n;
        assert (this._$3 == 0);
        Entry[] entryArray = this.table;
        Entry[] entryArray2 = new Entry[entryArray.length * 2];
        Scope scope = this;
        while (scope != null) {
            if (scope.table == entryArray) {
                assert (scope == this || scope._$3 != 0);
                scope.table = entryArray2;
                scope.hashMask = entryArray2.length - 1;
            }
            scope = scope.next;
        }
        for (n = 0; n < entryArray2.length; ++n) {
            entryArray2[n] = _$2;
        }
        for (n = 0; n < entryArray.length; ++n) {
            this._$1(entryArray[n]);
        }
    }

    private void _$1(Entry entry) {
        if (entry.sym != null) {
            this._$1(entry._$1);
            int n = entry.sym.name.index & this.hashMask;
            entry._$1 = this.table[n];
            this.table[n] = entry;
        }
    }

    public void enter(Symbol symbol) {
        assert (this._$3 == 0);
        this.enter(symbol, this);
    }

    public void enter(Symbol symbol, Scope scope) {
        Entry entry;
        assert (this._$3 == 0);
        if (this.nelems * 3 >= this.hashMask * 2) {
            this._$1();
        }
        int n = symbol.name.index & this.hashMask;
        this.table[n] = entry = this.makeEntry(symbol, this.table[n], this.elems, scope);
        this.elems = entry;
        ++this.nelems;
    }

    Entry makeEntry(Symbol symbol, Entry entry, Entry entry2, Scope scope) {
        return new Entry(symbol, entry, entry2, scope);
    }

    public void remove(Symbol symbol) {
        assert (this._$3 == 0);
        Entry entry = this.lookup(symbol.name);
        if (entry.scope == null) {
            return;
        }
        Entry entry2 = this.table[symbol.name.index & this.hashMask];
        if (entry2 == entry) {
            this.table[symbol.name.index & this.hashMask] = entry._$1;
        } else {
            while (true) {
                if (entry2._$1 == entry) {
                    entry2._$1 = entry._$1;
                    break;
                }
                entry2 = entry2._$1;
            }
        }
        entry2 = this.elems;
        if (entry2 == entry) {
            this.elems = entry.sibling;
        } else {
            while (true) {
                if (entry2.sibling == entry) {
                    entry2.sibling = entry.sibling;
                    break;
                }
                entry2 = entry2.sibling;
            }
        }
    }

    public void enterIfAbsent(Symbol symbol) {
        assert (this._$3 == 0);
        Entry entry = this.lookup(symbol.name);
        while (entry.scope == this && entry.sym.kind != symbol.kind) {
            entry = entry.next();
        }
        if (entry.scope != this) {
            this.enter(symbol);
        }
    }

    public boolean includes(Symbol symbol) {
        Entry entry = this.lookup(symbol.name);
        while (entry.scope == this) {
            if (entry.sym == symbol) {
                return true;
            }
            entry = entry.next();
        }
        return false;
    }

    public Entry lookup(Name name) {
        Entry entry = this.table[name.index & this.hashMask];
        while (entry.scope != null && entry.sym.name != name) {
            entry = entry._$1;
        }
        return entry;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Scope[");
        Entry entry = this.elems;
        while (entry != null) {
            if (entry != this.elems) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(entry.sym);
            entry = entry.sibling;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static class ErrorScope
    extends Scope {
        ErrorScope(Scope scope, Symbol symbol, Entry[] entryArray) {
            super(scope, symbol, entryArray);
        }

        public ErrorScope(Symbol symbol) {
            super(symbol);
        }

        public Scope dup() {
            return new ErrorScope(this, this.owner, this.table);
        }

        public Scope dupUnshared() {
            return new ErrorScope(this, this.owner, (Entry[])this.table.clone());
        }

        public Entry lookup(Name name) {
            Entry entry = super.lookup(name);
            if (entry.scope == null) {
                return new Entry(this.owner, null, null, null);
            }
            return entry;
        }
    }

    public static class DelegatedScope
    extends Scope {
        Scope delegatee;
        public static final Entry[] emptyTable = new Entry[0];

        public DelegatedScope(Scope scope) {
            super(scope, scope.owner, emptyTable);
            this.delegatee = scope;
        }

        public Scope dup() {
            return new DelegatedScope(this.next);
        }

        public Scope dupUnshared() {
            return new DelegatedScope(this.next);
        }

        public Scope leave() {
            return this.next;
        }

        public void enter(Symbol symbol) {
        }

        public void enter(Symbol symbol, Scope scope) {
        }

        public void remove(Symbol symbol) {
            throw new AssertionError(symbol);
        }

        public Entry lookup(Name name) {
            return this.delegatee.lookup(name);
        }
    }

    public static class ImportScope
    extends Scope {
        public ImportScope(Symbol symbol) {
            super(symbol);
        }

        Entry makeEntry(Symbol symbol, Entry entry, Entry entry2, Scope scope) {
            return new ImportEntry(symbol, entry, entry2, scope);
        }

        public Entry lookup(Name name) {
            Entry entry = this.table[name.index & this.hashMask];
            while (entry.scope != null && (entry.sym.name != name || entry.sym.owner != entry.scope.owner)) {
                entry = entry._$1;
            }
            return entry;
        }

        static class ImportEntry
        extends Entry {
            ImportEntry(Symbol symbol, Entry entry, Entry entry2, Scope scope) {
                super(symbol, entry, entry2, scope);
            }

            public Entry next() {
                Entry entry = ((Entry)this)._$1;
                while (entry.scope != null && (entry.sym.name != this.sym.name || entry.sym.owner != entry.scope.owner)) {
                    entry = entry._$1;
                }
                return entry;
            }
        }
    }

    public static class Entry {
        public Symbol sym;
        private Entry _$1;
        public Entry sibling;
        public Scope scope;

        public Entry(Symbol symbol, Entry entry, Entry entry2, Scope scope) {
            this.sym = symbol;
            this._$1 = entry;
            this.sibling = entry2;
            this.scope = scope;
        }

        public Entry next() {
            Entry entry = this._$1;
            while (entry.scope != null && entry.sym.name != this.sym.name) {
                entry = entry._$1;
            }
            return entry;
        }
    }
}

