/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.jvm.ByteCodes;
import com.sun.tools.javac.jvm.Code;
import com.sun.tools.javac.jvm.Pool;
import com.sun.tools.javac.tree.Tree;

public class Items {
    Pool pool;
    Code code;
    Symtab syms;
    Types types;
    private final Item _$4;
    private final Item _$3;
    private final Item _$2;
    private final Item[] _$1 = new Item[9];

    public Items(Pool pool, Code code, Symtab symtab, Types types) {
        this.code = code;
        this.pool = pool;
        this.types = types;
        this._$4 = new Item(8){

            public String toString() {
                return "void";
            }
        };
        this._$3 = new SelfItem(false);
        this._$2 = new SelfItem(true);
        for (int i = 0; i < 8; ++i) {
            this._$1[i] = new StackItem(i);
        }
        this._$1[8] = this._$4;
        this.syms = symtab;
    }

    Item makeVoidItem() {
        return this._$4;
    }

    Item makeThisItem() {
        return this._$3;
    }

    Item makeSuperItem() {
        return this._$2;
    }

    Item makeStackItem(Type type) {
        return this._$1[Code.typecode(type)];
    }

    Item makeIndexedItem(Type type) {
        return new IndexedItem(type);
    }

    LocalItem makeLocalItem(Symbol.VarSymbol varSymbol) {
        return new LocalItem(varSymbol.erasure(this.types), varSymbol.adr);
    }

    private LocalItem _$1(Type type, int n) {
        return new LocalItem(type, n);
    }

    Item makeStaticItem(Symbol symbol) {
        return new StaticItem(symbol);
    }

    Item makeMemberItem(Symbol symbol, boolean bl) {
        return new MemberItem(symbol, bl);
    }

    Item makeImmediateItem(Type type, Object object) {
        return new ImmediateItem(type, object);
    }

    Item makeAssignItem(Item item) {
        return new AssignItem(item);
    }

    CondItem makeCondItem(int n, Code.Chain chain, Code.Chain chain2) {
        return new CondItem(n, chain, chain2);
    }

    CondItem makeCondItem(int n) {
        return this.makeCondItem(n, null, null);
    }

    class CondItem
    extends Item {
        Code.Chain trueJumps;
        Code.Chain falseJumps;
        int opcode;
        Tree tree;

        CondItem(int n, Code.Chain chain, Code.Chain chain2) {
            super(5);
            this.opcode = n;
            this.trueJumps = chain;
            this.falseJumps = chain2;
        }

        Item load() {
            Code.Chain chain = null;
            Code.Chain chain2 = this.jumpFalse();
            if (!this.isFalse()) {
                Items.this.code.resolve(this.trueJumps);
                Items.this.code.emitop0(4);
                chain = Items.this.code.branch(167);
            }
            if (chain2 != null) {
                Items.this.code.resolve(chain2);
                Items.this.code.emitop0(3);
            }
            Items.this.code.resolve(chain);
            return Items.this._$1[this.typecode];
        }

        void duplicate() {
            this.load().duplicate();
        }

        void drop() {
            this.load().drop();
        }

        void stash(int n) {
            assert (false);
        }

        CondItem mkCond() {
            return this;
        }

        Code.Chain jumpTrue() {
            if (this.tree == null) {
                Code cfr_ignored_0 = Items.this.code;
                return Code.mergeChains(this.trueJumps, Items.this.code.branch(this.opcode));
            }
            int n = Items.this.code.curPc();
            Code cfr_ignored_1 = Items.this.code;
            Code.Chain chain = Code.mergeChains(this.trueJumps, Items.this.code.branch(this.opcode));
            Items.this.code.crt.put(this.tree, 128, n, Items.this.code.curPc());
            return chain;
        }

        Code.Chain jumpFalse() {
            if (this.tree == null) {
                Code cfr_ignored_0 = Items.this.code;
                Code cfr_ignored_1 = Items.this.code;
                return Code.mergeChains(this.falseJumps, Items.this.code.branch(Code.negate(this.opcode)));
            }
            int n = Items.this.code.curPc();
            Code cfr_ignored_2 = Items.this.code;
            Code cfr_ignored_3 = Items.this.code;
            Code.Chain chain = Code.mergeChains(this.falseJumps, Items.this.code.branch(Code.negate(this.opcode)));
            Items.this.code.crt.put(this.tree, 256, n, Items.this.code.curPc());
            return chain;
        }

        CondItem negate() {
            Code cfr_ignored_0 = Items.this.code;
            CondItem condItem = new CondItem(Code.negate(this.opcode), this.falseJumps, this.trueJumps);
            condItem.tree = this.tree;
            return condItem;
        }

        int width() {
            throw new AssertionError();
        }

        boolean isTrue() {
            return this.falseJumps == null && this.opcode == 167;
        }

        boolean isFalse() {
            return this.trueJumps == null && this.opcode == 168;
        }

        public String toString() {
            return "cond(" + Code.mnem(this.opcode) + ")";
        }
    }

    class AssignItem
    extends Item {
        Item lhs;

        AssignItem(Item item) {
            super(item.typecode);
            this.lhs = item;
        }

        Item load() {
            this.lhs.stash(this.typecode);
            this.lhs.store();
            return Items.this._$1[this.typecode];
        }

        void duplicate() {
            this.load().duplicate();
        }

        void drop() {
            this.lhs.store();
        }

        void stash(int n) {
            assert (false);
        }

        int width() {
            return this.lhs.width() + Code.width(this.typecode);
        }

        public String toString() {
            return "assign(lhs = " + this.lhs + ")";
        }
    }

    class ImmediateItem
    extends Item {
        Object value;

        ImmediateItem(Type type, Object object) {
            super(Code.typecode(type));
            this.value = object;
        }

        private void _$1() {
            int n = Items.this.pool.put(this.value);
            if (this.typecode == 1 || this.typecode == 3) {
                Items.this.code.emitop2(20, n);
            } else if (n <= 255) {
                Items.this.code.emitop1(18, n);
            } else {
                Items.this.code.emitop2(19, n);
            }
        }

        Item load() {
            switch (this.typecode) {
                case 0: 
                case 5: 
                case 6: 
                case 7: {
                    int n = ((Number)this.value).intValue();
                    if (-1 <= n && n <= 5) {
                        Items.this.code.emitop0(3 + n);
                        break;
                    }
                    if (-128 <= n && n <= 127) {
                        Items.this.code.emitop1(16, n);
                        break;
                    }
                    if (Short.MIN_VALUE <= n && n <= Short.MAX_VALUE) {
                        Items.this.code.emitop2(17, n);
                        break;
                    }
                    this._$1();
                    break;
                }
                case 1: {
                    long l = ((Number)this.value).longValue();
                    if (l == 0L || l == 1L) {
                        Items.this.code.emitop0(9 + (int)l);
                        break;
                    }
                    this._$1();
                    break;
                }
                case 2: {
                    float f = ((Number)this.value).floatValue();
                    if (this._$1(f) || (double)f == 1.0 || (double)f == 2.0) {
                        Items.this.code.emitop0(11 + (int)f);
                        break;
                    }
                    this._$1();
                    break;
                }
                case 3: {
                    double d = ((Number)this.value).doubleValue();
                    if (this._$1(d) || d == 1.0) {
                        Items.this.code.emitop0(14 + (int)d);
                        break;
                    }
                    this._$1();
                    break;
                }
                case 4: {
                    this._$1();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return Items.this._$1[this.typecode];
        }

        private boolean _$1(float f) {
            return f == 0.0f && 1.0f / f > 0.0f;
        }

        private boolean _$1(double d) {
            return d == 0.0 && 1.0 / d > 0.0;
        }

        CondItem mkCond() {
            int n = ((Number)this.value).intValue();
            return Items.this.makeCondItem(n != 0 ? 167 : 168);
        }

        Item coerce(int n) {
            if (this.typecode == n) {
                return this;
            }
            switch (n) {
                case 0: {
                    if (Code.truncate(this.typecode) == 0) {
                        return this;
                    }
                    return new ImmediateItem(Items.this.syms.intType, ((Number)this.value).intValue());
                }
                case 1: {
                    return new ImmediateItem(Items.this.syms.longType, ((Number)this.value).longValue());
                }
                case 2: {
                    return new ImmediateItem(Items.this.syms.floatType, Float.valueOf(((Number)this.value).floatValue()));
                }
                case 3: {
                    return new ImmediateItem(Items.this.syms.doubleType, ((Number)this.value).doubleValue());
                }
                case 5: {
                    return new ImmediateItem(Items.this.syms.byteType, (byte)((Number)this.value).intValue());
                }
                case 6: {
                    return new ImmediateItem(Items.this.syms.charType, (char)((Number)this.value).intValue());
                }
                case 7: {
                    return new ImmediateItem(Items.this.syms.shortType, (short)((Number)this.value).intValue());
                }
            }
            return super.coerce(n);
        }

        public String toString() {
            return "immediate(" + this.value + ")";
        }
    }

    class MemberItem
    extends Item {
        Symbol member;
        boolean nonvirtual;

        MemberItem(Symbol symbol, boolean bl) {
            super(Code.typecode(symbol.erasure(Items.this.types)));
            this.member = symbol;
            this.nonvirtual = bl;
        }

        Item load() {
            Items.this.code.emitop2(180, Items.this.pool.put(this.member));
            return Items.this._$1[this.typecode];
        }

        void store() {
            Items.this.code.emitop2(181, Items.this.pool.put(this.member));
        }

        Item invoke() {
            Type.MethodType methodType = (Type.MethodType)this.member.externalType(Items.this.types);
            int n = Code.typecode(methodType.restype);
            if ((this.member.owner.flags() & 0x200L) != 0L) {
                Items.this.code.emitInvokeinterface(Items.this.pool.put(this.member), methodType);
            } else if (this.nonvirtual) {
                Items.this.code.emitInvokespecial(Items.this.pool.put(this.member), methodType);
            } else {
                Items.this.code.emitInvokevirtual(Items.this.pool.put(this.member), methodType);
            }
            return Items.this._$1[n];
        }

        void duplicate() {
            Items.this._$1[4].duplicate();
        }

        void drop() {
            Items.this._$1[4].drop();
        }

        void stash(int n) {
            Items.this._$1[4].stash(n);
        }

        int width() {
            return 1;
        }

        public String toString() {
            return "member(" + this.member + (this.nonvirtual ? " nonvirtual)" : ")");
        }
    }

    class StaticItem
    extends Item {
        Symbol member;

        StaticItem(Symbol symbol) {
            super(Code.typecode(symbol.erasure(Items.this.types)));
            this.member = symbol;
        }

        Item load() {
            Items.this.code.emitop2(178, Items.this.pool.put(this.member));
            return Items.this._$1[this.typecode];
        }

        void store() {
            Items.this.code.emitop2(179, Items.this.pool.put(this.member));
        }

        Item invoke() {
            Type.MethodType methodType = (Type.MethodType)this.member.erasure(Items.this.types);
            int n = Code.width(methodType.argtypes);
            int n2 = Code.typecode(methodType.restype);
            int n3 = Code.width(n2) - n;
            Items.this.code.emitInvokestatic(Items.this.pool.put(this.member), methodType);
            return Items.this._$1[n2];
        }

        public String toString() {
            return "static(" + this.member + ")";
        }
    }

    class LocalItem
    extends Item {
        int reg;
        Type type;

        LocalItem(Type type, int n) {
            super(Code.typecode(type));
            assert (n >= 0);
            this.type = type;
            this.reg = n;
        }

        Item load() {
            if (this.reg <= 3) {
                Items.this.code.emitop0(26 + Code.truncate(this.typecode) * 4 + this.reg);
            } else {
                Items.this.code.emitop1w(21 + Code.truncate(this.typecode), this.reg);
            }
            return Items.this._$1[this.typecode];
        }

        void store() {
            if (this.reg <= 3) {
                Items.this.code.emitop0(59 + Code.truncate(this.typecode) * 4 + this.reg);
            } else {
                Items.this.code.emitop1w(54 + Code.truncate(this.typecode), this.reg);
            }
            Items.this.code.setDefined(this.reg);
        }

        void incr(int n) {
            if (this.typecode == 0 && n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
                Items.this.code.emitop1w(132, this.reg, n);
            } else {
                this.load();
                if (n >= 0) {
                    Items.this.makeImmediateItem(Items.this.syms.intType, n).load();
                    Items.this.code.emitop0(96);
                } else {
                    Items.this.makeImmediateItem(Items.this.syms.intType, -n).load();
                    Items.this.code.emitop0(100);
                }
                Items.this.makeStackItem(Items.this.syms.intType).coerce(this.typecode);
                this.store();
            }
        }

        public String toString() {
            return "localItem(type=" + this.type + "; reg=" + this.reg + ")";
        }
    }

    class SelfItem
    extends Item {
        boolean isSuper;

        SelfItem(boolean bl) {
            super(4);
            this.isSuper = bl;
        }

        Item load() {
            Items.this.code.emitop0(42);
            return Items.this._$1[this.typecode];
        }

        public String toString() {
            return this.isSuper ? "super" : "this";
        }
    }

    class IndexedItem
    extends Item {
        IndexedItem(Type type) {
            super(Code.typecode(type));
        }

        Item load() {
            Items.this.code.emitop0(46 + this.typecode);
            return Items.this._$1[this.typecode];
        }

        void store() {
            Items.this.code.emitop0(79 + this.typecode);
        }

        void duplicate() {
            Items.this.code.emitop0(92);
        }

        void drop() {
            Items.this.code.emitop0(88);
        }

        void stash(int n) {
            Items.this.code.emitop0(91 + 3 * (Code.width(n) - 1));
        }

        int width() {
            return 2;
        }

        public String toString() {
            return "indexed(" + ByteCodes.typecodeNames[this.typecode] + ")";
        }
    }

    class StackItem
    extends Item {
        StackItem(int n) {
            super(n);
        }

        Item load() {
            return this;
        }

        void duplicate() {
            Items.this.code.emitop0(this.width() == 2 ? 92 : 89);
        }

        void drop() {
            Items.this.code.emitop0(this.width() == 2 ? 88 : 87);
        }

        void stash(int n) {
            Items.this.code.emitop0((this.width() == 2 ? 91 : 90) + 3 * (Code.width(n) - 1));
        }

        int width() {
            return Code.width(this.typecode);
        }

        public String toString() {
            return "stack(" + ByteCodes.typecodeNames[this.typecode] + ")";
        }
    }

    abstract class Item {
        int typecode;

        Item(int n) {
            this.typecode = n;
        }

        Item load() {
            throw new AssertionError();
        }

        void store() {
            throw new AssertionError((Object)("store unsupported: " + this));
        }

        Item invoke() {
            throw new AssertionError(this);
        }

        void duplicate() {
        }

        void drop() {
        }

        void stash(int n) {
            Items.this._$1[n].duplicate();
        }

        CondItem mkCond() {
            this.load();
            return Items.this.makeCondItem(154);
        }

        Item coerce(int n) {
            if (this.typecode == n) {
                return this;
            }
            this.load();
            int n2 = Code.truncate(this.typecode);
            int n3 = Code.truncate(n);
            if (n2 != n3) {
                int n4 = n3 > n2 ? n3 - 1 : n3;
                Items.this.code.emitop0(133 + n2 * 3 + n4);
            }
            if (n != n3) {
                Items.this.code.emitop0(145 + n - 5);
            }
            return Items.this._$1[n];
        }

        Item coerce(Type type) {
            return this.coerce(Code.typecode(type));
        }

        int width() {
            return 0;
        }

        public abstract String toString();
    }
}

