/*
 * Decompiled with CFR 0.152.
 */
package org.apusic.jocky.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.compilers.DefaultCompilerAdapter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class JockyCompilerAdapter
extends DefaultCompilerAdapter {
    public boolean execute() throws BuildException {
        this.attributes.log("Using jockey compiler", 3);
        Commandline cmd = new Commandline();
        String javaExe = String.valueOf(System.getProperty("java.home")) + File.separator + "bin" + File.separator + "java.exe";
        cmd.setExecutable(javaExe);
        this.setupJocCommandlineSwitches(cmd);
        int firstFileName = this.assumeJava11() ? -1 : cmd.size();
        this.logAndAddFilesToCompile(cmd);
        return this.executeExternalCompile(cmd.getCommandline(), firstFileName, true) == 0;
    }

    protected Commandline setupJocCommandlineSwitches(Commandline cmd) {
        this.setupJavacCommandlineSwitches(cmd, true);
        if (this.attributes.getSource() != null) {
            cmd.createArgument().setValue("-source");
            cmd.createArgument().setValue(this.attributes.getSource());
        }
        return cmd;
    }

    protected Commandline setupJavacCommandlineSwitches(Commandline cmd, boolean useDebugLevel) {
        Path classpath = this.getCompileClasspath();
        Path sourcepath = null;
        sourcepath = this.compileSourcepath != null ? this.compileSourcepath : this.src;
        String memoryParameterPrefix = "-X";
        if (this.memoryInitialSize != null) {
            if (!this.attributes.isForkedJavac()) {
                this.attributes.log("Since fork is false, ignoring memoryInitialSize setting.", 1);
            } else {
                cmd.createArgument().setValue(String.valueOf(memoryParameterPrefix) + "ms" + this.memoryInitialSize);
            }
        }
        if (this.memoryMaximumSize != null) {
            if (!this.attributes.isForkedJavac()) {
                this.attributes.log("Since fork is false, ignoring memoryMaximumSize setting.", 1);
            } else {
                cmd.createArgument().setValue(String.valueOf(memoryParameterPrefix) + "mx" + this.memoryMaximumSize);
            }
        }
        String jockyLocation = this.getProject().getProperty("org.apusic.jocky.location");
        String scrambleLevel = this.getProject().getProperty("org.apusic.jocky.scramblelevel");
        if (scrambleLevel == null) {
            scrambleLevel = "package";
        }
        cmd.createArgument().setValue("-jar");
        cmd.createArgument().setValue(jockyLocation);
        cmd.createArgument().setValue("-scramble:" + scrambleLevel);
        if (this.attributes.getNowarn()) {
            cmd.createArgument().setValue("-nowarn");
        }
        if (this.deprecation) {
            cmd.createArgument().setValue("-deprecation");
        }
        if (this.destDir != null) {
            cmd.createArgument().setValue("-d");
            cmd.createArgument().setFile(this.destDir);
        }
        cmd.createArgument().setValue("-classpath");
        if (this.assumeJava11()) {
            Path cp = new Path(this.project);
            if (this.bootclasspath != null) {
                cp.append(this.bootclasspath);
            }
            if (this.extdirs != null) {
                cp.addExtdirs(this.extdirs);
            }
            cp.append(classpath);
            cp.append(sourcepath);
            cmd.createArgument().setPath(cp);
        } else {
            cmd.createArgument().setPath(classpath);
            if (sourcepath.size() > 0) {
                cmd.createArgument().setValue("-sourcepath");
                cmd.createArgument().setPath(sourcepath);
            }
            if (this.target != null) {
                cmd.createArgument().setValue("-target");
                cmd.createArgument().setValue(this.target);
            }
            if (this.bootclasspath != null && this.bootclasspath.size() > 0) {
                cmd.createArgument().setValue("-bootclasspath");
                cmd.createArgument().setPath(this.bootclasspath);
            }
            if (this.extdirs != null && this.extdirs.size() > 0) {
                cmd.createArgument().setValue("-extdirs");
                cmd.createArgument().setPath(this.extdirs);
            }
        }
        if (this.encoding != null) {
            cmd.createArgument().setValue("-encoding");
            cmd.createArgument().setValue(this.encoding);
        }
        if (this.debug) {
            if (useDebugLevel && !this.assumeJava11()) {
                String debugLevel = this.attributes.getDebugLevel();
                if (debugLevel != null) {
                    cmd.createArgument().setValue("-g:" + debugLevel);
                } else {
                    cmd.createArgument().setValue("-g");
                }
            } else {
                cmd.createArgument().setValue("-g");
            }
        } else if (!this.assumeJava11()) {
            cmd.createArgument().setValue("-g:none");
        }
        if (this.optimize) {
            cmd.createArgument().setValue("-O");
        }
        if (this.depend) {
            if (this.assumeJava11()) {
                cmd.createArgument().setValue("-depend");
            } else if (this.assumeJava12()) {
                cmd.createArgument().setValue("-Xdepend");
            } else {
                this.attributes.log("depend attribute is not supported by the modern compiler", 1);
            }
        }
        if (this.verbose) {
            cmd.createArgument().setValue("-verbose");
        }
        this.addCurrentCompilerArgs(cmd);
        return cmd;
    }
}

