/*
 * Decompiled with CFR 0.152.
 */
package org.apusic.jocky.ant;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.JavaEnvUtils;

public class JockyTask
extends Task {
    private String enable = "false";
    private String jar = null;
    private String level = null;
    public static final String JOCKY_LOCATION = "org.apusic.jocky.location";
    public static final String JOCKY_SCRAMBLE_LEVEL = "org.apusic.jocky.scramblelevel";

    public void execute() throws BuildException {
        if (this.getJar() != null && this.getJar().trim().length() > 0) {
            this.getProject().setProperty(JOCKY_LOCATION, this.getJar());
        }
        if (this.getLevel() != null) {
            this.getProject().setProperty(JOCKY_SCRAMBLE_LEVEL, this.getLevel());
        }
        if (this.isJockyEnabled()) {
            if (this.getProject().getProperty(JOCKY_LOCATION) == null) {
                throw new BuildException("jocky jar can not be null");
            }
            this.log("Jocky enabled");
            this.getProject().setProperty("build.compiler", "org.apusic.jocky.ant.JockyCompilerAdapter");
        } else {
            this.log("Jocky disabled");
            String defaultValue = "";
            defaultValue = JavaEnvUtils.isJavaVersion((String)"1.1") ? "javac1.1" : (JavaEnvUtils.isJavaVersion((String)"1.2") ? "javac1.2" : (JavaEnvUtils.isJavaVersion((String)"1.3") ? "javac1.3" : (JavaEnvUtils.isJavaVersion((String)"1.4") ? "javac1.4" : (JavaEnvUtils.isJavaVersion((String)"1.5") ? "javac1.5" : "classic"))));
            this.getProject().setProperty("build.compiler", defaultValue);
        }
    }

    private boolean isJockyEnabled() {
        return "true".equalsIgnoreCase(this.enable) || "yes".equalsIgnoreCase(this.enable);
    }

    public String getEnable() {
        return this.enable;
    }

    public void setEnable(String enable) {
        this.enable = enable;
    }

    public String getJar() {
        return this.jar;
    }

    public void setJar(String jockyJar) {
        this.jar = jockyJar;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String scrambleLevel) {
        this.level = scrambleLevel;
        if (!("none".equals(scrambleLevel) || "private".equals(scrambleLevel) || "package".equals(scrambleLevel) || "protected".equals(scrambleLevel) || "public".equals(scrambleLevel) || "all".equals(scrambleLevel))) {
            throw new BuildException("scrambleLevel '" + scrambleLevel + "' is invalid, it should be one of:" + "[none|private|package|protected|public|all]");
        }
    }
}

