/*
 * Decompiled with CFR 0.152.
 */
package org.apusic.jocky.actions;

import org.apusic.jocky.JockyPlugin;
import org.apusic.jocky.actions.BaseJockyAction;
import org.apusic.jocky.actions.JockySettingAction;
import org.apusic.jocky.preference.IJockyPreference;
import org.apusic.jocky.util.Utils;
import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchShortcut;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntTargetNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class JockyNowAction
extends BaseJockyAction
implements IObjectActionDelegate {
    public void run(IAction action) {
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            IJockyPreference preference = JockyPlugin.getDefault().getJockyPreferenceStore().getPreference(javaProject);
            IProject project = javaProject.getProject();
            IFile buildFile = null;
            if (preference.getBuildFile() != null && preference.getBuildFile().trim().length() > 0) {
                buildFile = project.getFile(preference.getBuildFile());
            }
            if (buildFile != null && buildFile.exists()) {
                AntTargetNode[] targets = AntUtil.getTargets((String)buildFile.getLocation().toOSString());
                if (targets == null) {
                    this.invalidBuildFile(buildFile.getName());
                } else {
                    AntTargetNode node = null;
                    int i = 0;
                    while (i < targets.length) {
                        if ("build".equals(targets[i].getTargetName())) {
                            node = targets[i];
                            break;
                        }
                        ++i;
                    }
                    if (node != null) {
                        this.build(node);
                    } else {
                        this.invalidBuildFile(buildFile.getName());
                    }
                }
            } else {
                boolean result = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Question", (String)"Jocky build file not exist, do you want create it?");
                if (result) {
                    JockySettingAction settingAction = new JockySettingAction();
                    settingAction.selection = this.selection;
                    settingAction.run(action);
                }
            }
        }
    }

    private void invalidBuildFile(String buildFileName) {
        Utils.showErrorDialog("Jocky build file '" + buildFileName + "' is invalid.");
    }

    private void build(final AntTargetNode node) {
        UIJob job = new UIJob("Jocky"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                AntLaunchShortcut shortcut = new AntLaunchShortcut();
                shortcut.setShowDialog(false);
                shortcut.launch((AntElementNode)node, "run");
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

