/*
 * Decompiled with CFR 0.152.
 */
package org.apusic.jocky.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Commandline;
import org.apusic.jocky.JockyPlugin;
import org.apusic.jocky.internal.EclipseClasspath;
import org.apusic.jocky.internal.ExportUtil;
import org.apusic.jocky.preference.IJockyPreference;
import org.apusic.jocky.util.Utils;
import org.eclipse.ant.internal.ui.datatransfer.AppletUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JockyBuildFileCreator {
    protected static final String WARNING = " WARNING: Jocky autogenerated file. " + ExportUtil.NEWLINE + "              Any modifications will be overwritten." + ExportUtil.NEWLINE;
    private static final String USER_TARGET = "<target name=\"help\">" + ExportUtil.NEWLINE + "    <echo message=\"Please run: $ ant -v -projecthelp\"/>" + ExportUtil.NEWLINE + "</target>";
    private Document doc;
    private Element root;
    private String projectName;
    private String projectRoot;

    private JockyBuildFileCreator() {
    }

    public JockyBuildFileCreator(IJavaProject project) throws ParserConfigurationException {
        this.projectName = project.getProject().getName();
        this.projectRoot = ExportUtil.getProjectRoot(project);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        this.doc = dbf.newDocumentBuilder().newDocument();
    }

    public static void create(IJavaProject javaProject) throws JavaModelException, ParserConfigurationException, TransformerConfigurationException, TransformerException, IOException, CoreException {
        JockyBuildFileCreator instance = new JockyBuildFileCreator();
        instance.createBuildFiles(javaProject);
    }

    public void createBuildFiles(IJavaProject javaProject) throws JavaModelException, ParserConfigurationException, TransformerConfigurationException, TransformerException, IOException, CoreException {
        HashSet<IJavaProject> allSubProjects = new HashSet<IJavaProject>();
        allSubProjects.add(javaProject);
        Iterator iter = allSubProjects.iterator();
        while (iter.hasNext()) {
            TreeMap variable2valueMap = new TreeMap();
            IJavaProject mainProject = (IJavaProject)iter.next();
            this.projectName = mainProject.getProject().getName();
            this.projectRoot = ExportUtil.getProjectRoot(mainProject);
            IJockyPreference preference = JockyPlugin.getDefault().getJockyPreferenceStore().getPreference(mainProject);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            this.doc = dbf.newDocumentBuilder().newDocument();
            this.createRoot();
            this.createJockyProperties(preference);
            Set subProjects = ExportUtil.getClasspathProjects(mainProject);
            Element classpathElement = this.createClasspath(mainProject, subProjects, variable2valueMap);
            this.addSubClasspaths(variable2valueMap, subProjects);
            EclipseClasspath classpath = new EclipseClasspath(mainProject);
            List classDirsUnique = classpath.getClassDirsUnique();
            this.createInit(classDirsUnique);
            this.createClean(classDirsUnique);
            this.createBuild(subProjects, classpath.class2sourcesMap, classpath.class2includesMap, classpath.class2excludesMap);
            this.createRun(variable2valueMap);
            this.createProperty(variable2valueMap, classpathElement);
            String xml = ExportUtil.toString(this.doc);
            BufferedWriter out = new BufferedWriter(new FileWriter(String.valueOf(this.projectRoot) + File.separator + preference.getBuildFile()));
            out.write(xml.toString());
            out.close();
            mainProject.getProject().getFile(preference.getBuildFile()).refreshLocal(0, null);
        }
    }

    public void createProperty(Map variable2valueMap, Element classpathElement) {
        Iterator iterator = variable2valueMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = (String)variable2valueMap.get(key);
            Element prop = this.doc.createElement("property");
            prop.setAttribute("name", key);
            prop.setAttribute("value", value);
            this.root.insertBefore(prop, classpathElement);
        }
    }

    public void createRoot() {
        this.root = this.doc.createElement("project");
        this.root.setAttribute("name", String.valueOf(this.projectName) + ".jocky");
        this.root.setAttribute("default", "build");
        this.root.setAttribute("basedir", ".");
        this.doc.appendChild(this.root);
        Comment comment = this.doc.createComment(WARNING);
        this.doc.insertBefore(comment, this.root);
    }

    public Element createClasspath(IJavaProject mainProject, Set subProjects, Map variable2valueMap) throws JavaModelException {
        Element element;
        if (subProjects.size() == 0) {
            element = this.createClasspath("project.classpath", mainProject, null, variable2valueMap);
        } else {
            element = this.createMainClasspath(subProjects);
            this.createClasspath("mainproject.classpath", mainProject, null, variable2valueMap);
        }
        return element;
    }

    public Element createClasspath(String pathId, IJavaProject project, String newProjectRoot, Map variable2valueMap) throws JavaModelException {
        Element element = this.doc.createElement("path");
        element.setAttribute("id", pathId);
        EclipseClasspath classpath = new EclipseClasspath(project, newProjectRoot);
        variable2valueMap.putAll(classpath.variable2valueMap);
        Iterator iterator = classpath.removeDuplicates(classpath.rawClassPathEntries).iterator();
        while (iterator.hasNext()) {
            String entry = (String)iterator.next();
            Element pathElement = this.doc.createElement("pathelement");
            pathElement.setAttribute("location", entry);
            element.appendChild(pathElement);
        }
        this.root.appendChild(element);
        return element;
    }

    public Element createMainClasspath(Set subProjects) {
        Element element = this.doc.createElement("path");
        element.setAttribute("id", "project.classpath");
        Element pathElement = this.doc.createElement("path");
        pathElement.setAttribute("refid", "mainproject.classpath");
        element.appendChild(pathElement);
        Iterator iter = subProjects.iterator();
        while (iter.hasNext()) {
            IJavaProject subProject = (IJavaProject)iter.next();
            String refid = String.valueOf(subProject.getProject().getName()) + ".classpath";
            pathElement = this.doc.createElement("path");
            pathElement.setAttribute("refid", refid);
            element.appendChild(pathElement);
        }
        this.root.appendChild(element);
        return element;
    }

    private void addSubClasspaths(Map variable2valueMap, Set subProjects) throws JavaModelException {
        Iterator iterator = subProjects.iterator();
        while (iterator.hasNext()) {
            IJavaProject subProject = (IJavaProject)iterator.next();
            String location = String.valueOf(subProject.getProject().getName()) + ".location";
            variable2valueMap.put(location, ExportUtil.getProjectRoot(subProject));
            EclipseClasspath classpath = new EclipseClasspath(subProject, "${" + location + "}");
            variable2valueMap.putAll(classpath.variable2valueMap);
            this.createClasspath(String.valueOf(subProject.getProject().getName()) + ".classpath", subProject, "${" + location + "}", variable2valueMap);
        }
    }

    public void createJockyProperties(IJockyPreference preference) {
        Element element = this.doc.createElement("property");
        element.setAttribute("name", "jocky.jar");
        element.setAttribute("value", Utils.getJockyLocation());
        this.root.appendChild(element);
        element = this.doc.createElement("property");
        element.setAttribute("name", "jocky.output.dir");
        element.setAttribute("value", preference.getCompileRootDir());
        this.root.appendChild(element);
        element = this.doc.createElement("property");
        element.setAttribute("name", "jocky.scramble.level");
        element.setAttribute("value", preference.getScrambleLevel());
        this.root.appendChild(element);
        element = this.doc.createElement("property");
        element.setAttribute("name", "target");
        element.setAttribute("value", preference.getTarget());
        this.root.appendChild(element);
    }

    public void createInit(List classDirs) {
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "init");
        Element childElement = this.doc.createElement("jocky");
        childElement.setAttribute("jar", "${jocky.jar}");
        childElement.setAttribute("level", "${jocky.scramble.level}");
        element.appendChild(childElement);
        childElement = this.doc.createElement("mkdir");
        childElement.setAttribute("dir", "${jocky.output.dir}");
        element.appendChild(childElement);
        Iterator iterator = classDirs.iterator();
        while (iterator.hasNext()) {
            String classDir = (String)iterator.next();
            if (classDir.equals(".")) continue;
            Element pathElement = this.doc.createElement("mkdir");
            pathElement.setAttribute("dir", "${jocky.output.dir}/" + classDir);
            element.appendChild(pathElement);
        }
        this.root.appendChild(element);
    }

    public void createClean(List classDirs) {
        Element element = this.doc.createElement("target");
        element.setAttribute("name", "clean");
        Iterator iterator = classDirs.iterator();
        while (iterator.hasNext()) {
            String classDir = (String)iterator.next();
            if (classDir.equals(".")) continue;
            Element deleteElement = this.doc.createElement("delete");
            deleteElement.setAttribute("dir", "${jocky.output.dir}/" + classDir);
            element.appendChild(deleteElement);
        }
        Element childElement = this.doc.createElement("delete");
        childElement.setAttribute("dir", "${jocky.output.dir}");
        element.appendChild(childElement);
        this.root.appendChild(element);
    }

    public void createBuild(Set subProjects, Map class2sourcesMap, Map class2includesMap, Map class2excludesMap) {
        Element element = this.doc.createElement("target");
        element.setAttribute("depends", "init");
        element.setAttribute("name", "build");
        Element echoElement = this.doc.createElement("echo");
        echoElement.setAttribute("message", "${ant.project.name}: ${ant.file}");
        element.appendChild(echoElement);
        Element jockyElement = this.doc.createElement("jocky");
        jockyElement.setAttribute("enable", "true");
        element.appendChild(jockyElement);
        Iterator iterator = class2sourcesMap.keySet().iterator();
        while (iterator.hasNext()) {
            String classDir = (String)iterator.next();
            Set sources = (Set)class2sourcesMap.get(classDir);
            Set inclusions = (Set)class2includesMap.get(classDir);
            Set exclusions = (Set)class2excludesMap.get(classDir);
            Element javacElement = this.doc.createElement("javac");
            javacElement.setAttribute("destdir", "${jocky.output.dir}/" + classDir);
            javacElement.setAttribute("target", "${target}");
            Iterator iterator1 = sources.iterator();
            while (iterator1.hasNext()) {
                String src = (String)iterator1.next();
                Element srcElement = this.doc.createElement("src");
                srcElement.setAttribute("path", src);
                javacElement.appendChild(srcElement);
            }
            iterator1 = inclusions.iterator();
            while (iterator1.hasNext()) {
                String inclusion = (String)iterator1.next();
                Element includeElement = this.doc.createElement("include");
                includeElement.setAttribute("name", inclusion);
                javacElement.appendChild(includeElement);
            }
            iterator1 = exclusions.iterator();
            while (iterator1.hasNext()) {
                String exclusion = (String)iterator1.next();
                Element excludeElement = this.doc.createElement("exclude");
                excludeElement.setAttribute("name", exclusion);
                javacElement.appendChild(excludeElement);
            }
            Element classpathRefElement = this.doc.createElement("classpath");
            classpathRefElement.setAttribute("refid", "project.classpath");
            javacElement.appendChild(classpathRefElement);
            element.appendChild(javacElement);
        }
        this.root.appendChild(element);
    }

    private static void addVariable(Map variable2valueMap, String s) {
        if (s == null || s.equals("")) {
            return;
        }
        Pattern pattern = Pattern.compile("\\$\\{.*?\\}");
        Matcher matcher = pattern.matcher(s);
        while (matcher.find()) {
            String value;
            String variable = matcher.group();
            try {
                value = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(variable);
            }
            catch (CoreException e) {
                value = variable;
            }
            variable2valueMap.put(ExportUtil.removePrefixAndSuffix(variable, "${", "}"), value);
        }
    }

    public void createRun(Map variable2valueMap) throws CoreException {
        ILaunchConfiguration[] confs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
        int i = 0;
        while (i < confs.length) {
            ILaunchConfiguration conf = confs[i];
            if (this.projectName.equals(conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, ""))) {
                if (conf.getType().getIdentifier().equals(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION)) {
                    this.addJavaApplication(variable2valueMap, conf);
                } else if (conf.getType().getIdentifier().equals(IJavaLaunchConfigurationConstants.ID_JAVA_APPLET)) {
                    this.addApplet(variable2valueMap, conf);
                } else if (conf.getType().getIdentifier().equals("org.eclipse.jdt.junit.launchconfig")) {
                    this.addJUnit(variable2valueMap, conf);
                }
            }
            ++i;
        }
    }

    public void addJavaApplication(Map variable2valueMap, ILaunchConfiguration conf) throws CoreException {
        Element element = this.doc.createElement("target");
        element.setAttribute("name", conf.getName());
        Element javaElement = this.doc.createElement("java");
        javaElement.setAttribute("fork", "yes");
        javaElement.setAttribute("classname", conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, ""));
        javaElement.setAttribute("failonerror", "true");
        String dir = conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, "");
        JockyBuildFileCreator.addVariable(variable2valueMap, dir);
        if (!dir.equals("")) {
            javaElement.setAttribute("dir", dir);
        }
        if (!conf.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true)) {
            javaElement.setAttribute("newenvironment", "true");
        }
        Map props = conf.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, new TreeMap());
        JockyBuildFileCreator.addElements(props, this.doc, javaElement, "env", "key", "value");
        JockyBuildFileCreator.addElements(conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, ""), this.doc, javaElement, "jvmarg", "value", variable2valueMap);
        JockyBuildFileCreator.addElements(conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, ""), this.doc, javaElement, "arg", "value", variable2valueMap);
        element.appendChild(javaElement);
        Element classpathRefElement = this.doc.createElement("classpath");
        classpathRefElement.setAttribute("refid", "project.classpath");
        javaElement.appendChild(classpathRefElement);
        this.root.appendChild(element);
    }

    public void addApplet(Map variable2valueMap, ILaunchConfiguration conf) throws CoreException {
        String value;
        String dir = conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, "");
        if (dir.equals("")) {
            dir = this.projectRoot;
        }
        JockyBuildFileCreator.addVariable(variable2valueMap, dir);
        try {
            value = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(dir);
        }
        catch (CoreException e) {
            value = null;
        }
        String htmlfile = String.valueOf(value != null ? value : dir) + File.separator + conf.getName() + ".html";
        AppletUtil.buildHTMLFile((ILaunchConfiguration)conf, (String)htmlfile);
        Element element = this.doc.createElement("target");
        element.setAttribute("name", conf.getName());
        Element javaElement = this.doc.createElement("java");
        javaElement.setAttribute("fork", "yes");
        javaElement.setAttribute("classname", conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_APPLETVIEWER_CLASS, "sun.applet.AppletViewer"));
        javaElement.setAttribute("failonerror", "true");
        if (value != null) {
            javaElement.setAttribute("dir", dir);
        }
        JockyBuildFileCreator.addElements(conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, ""), this.doc, javaElement, "jvmarg", "value", variable2valueMap);
        JockyBuildFileCreator.addElements(conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, ""), this.doc, javaElement, "arg", "value", variable2valueMap);
        JockyBuildFileCreator.addElements(String.valueOf(conf.getName()) + ".html", this.doc, javaElement, "arg", "value", variable2valueMap);
        element.appendChild(javaElement);
        Element classpathRefElement = this.doc.createElement("classpath");
        classpathRefElement.setAttribute("refid", "project.classpath");
        javaElement.appendChild(classpathRefElement);
        this.root.appendChild(element);
    }

    public void addJUnit(Map variable2valueMap, ILaunchConfiguration conf) throws CoreException {
        String testClass = conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
        Element element = this.doc.createElement("target");
        element.setAttribute("name", conf.getName());
        Element junitElement = this.doc.createElement("junit");
        junitElement.setAttribute("fork", "yes");
        junitElement.setAttribute("printsummary", "withOutAndErr");
        String dir = conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, "");
        JockyBuildFileCreator.addVariable(variable2valueMap, dir);
        if (!dir.equals("")) {
            junitElement.setAttribute("dir", dir);
        }
        if (!conf.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true)) {
            junitElement.setAttribute("newenvironment", "true");
        }
        Element formatterElement = this.doc.createElement("formatter");
        formatterElement.setAttribute("type", "plain");
        junitElement.appendChild(formatterElement);
        if (!testClass.equals("")) {
            Element testElement = this.doc.createElement("test");
            testElement.setAttribute("name", testClass);
            junitElement.appendChild(testElement);
        } else {
            String container = conf.getAttribute("org.eclipse.jdt.junit.CONTAINER", "");
            IType[] types = ExportUtil.findTestsInContainer(container);
            int i = 0;
            while (i < types.length) {
                IType type = types[i];
                Element testElement = this.doc.createElement("test");
                testElement.setAttribute("name", type.getFullyQualifiedName());
                junitElement.appendChild(testElement);
                ++i;
            }
        }
        Map props = conf.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, new TreeMap());
        JockyBuildFileCreator.addElements(props, this.doc, junitElement, "env", "key", "value");
        JockyBuildFileCreator.addElements(conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, ""), this.doc, junitElement, "jvmarg", "value", variable2valueMap);
        element.appendChild(junitElement);
        Element classpathRefElement = this.doc.createElement("classpath");
        classpathRefElement.setAttribute("refid", "project.classpath");
        junitElement.appendChild(classpathRefElement);
        this.root.appendChild(element);
    }

    private static void addElements(String cmdLineArgs, Document doc, Element element, String elementName, String attributeName, Map variable2valueMap) throws CoreException {
        try {
            Commandline commandline = new Commandline("dummyexecutable " + cmdLineArgs);
            String[] args = commandline.getArguments();
            int i = 0;
            while (i < args.length) {
                String arg = args[i];
                JockyBuildFileCreator.addVariable(variable2valueMap, arg);
                Element itemElement = doc.createElement(elementName);
                itemElement.setAttribute(attributeName, arg);
                element.appendChild(itemElement);
                ++i;
            }
        }
        catch (BuildException be) {
            throw new CoreException((IStatus)new Status(4, JockyPlugin.ID, 0, "error", (Throwable)be));
        }
    }

    private static void addElements(Map map, Document doc, Element element, String elementName, String keyAttributeName, String valueAttributeName) {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)map.get(key);
            Element itemElement = doc.createElement(elementName);
            itemElement.setAttribute(keyAttributeName, key);
            itemElement.setAttribute(valueAttributeName, value);
            element.appendChild(itemElement);
        }
    }
}

