/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.adb;

import com.wuntee.oter.OterStatics;
import com.wuntee.oter.adb.BackgroundAdbCommand;
import com.wuntee.oter.exception.CommandFailedException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class AdbShell
extends BackgroundAdbCommand {
    private static Logger logger = Logger.getLogger(AdbShell.class);
    private String prompt;

    public static void main(String[] args) throws Exception {
        AdbShell s = new AdbShell();
        s.start();
        s.getRootShell();
    }

    public AdbShell() {
        super("shell");
    }

    public boolean isRootShell() {
        return this.prompt.equals(OterStatics.ADB_ROOT_SHELL);
    }

    public int start() throws Exception {
        return this.execute();
    }

    @Override
    public int execute() throws Exception {
        super.execute();
        this.waitForNewPrompt();
        return 0;
    }

    private List<String> waitForNewPrompt() throws IOException {
        LinkedList<String> ret = new LinkedList<String>();
        String line = "";
        while (!this.isPrompt(line)) {
            char c = (char)this.stdout.read();
            if (c == '\r' || c == '\n') {
                if (!line.trim().equals("")) {
                    logger.debug((Object)("Line: " + line));
                    ret.add(line);
                }
                line = "";
                continue;
            }
            line = String.valueOf(line) + c;
        }
        this.prompt = line;
        logger.debug((Object)("Prompt: '" + line + "'"));
        return ret;
    }

    private boolean isPrompt(String line) {
        String[] stringArray = OterStatics.ADB_SHELLS;
        int n = OterStatics.ADB_SHELLS.length;
        int n2 = 0;
        while (n2 < n) {
            String prompt = stringArray[n2];
            if (line.equals(prompt)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public List<String> sendCommand(String command) throws IOException, CommandFailedException {
        List<String> ret = this._sendCommand(command);
        List<String> code = this._sendCommand("echo $?");
        if (!code.get(0).equals("0")) {
            throw new CommandFailedException(command, ret, code.get(0));
        }
        return ret;
    }

    private List<String> _sendCommand(String command) throws IOException {
        logger.debug((Object)("Sending command: " + command));
        LinkedList<String> ret = new LinkedList();
        this.stdin.write(String.valueOf(command) + "\n");
        this.stdin.flush();
        logger.debug((Object)"Waiting for prompt.");
        String line = "";
        while (!line.equals(this.prompt)) {
            char c = (char)this.stdout.read();
            if (c == '\r' || c == '\n') {
                if (!line.trim().equals("")) {
                    logger.debug((Object)("Line: " + line));
                    ret.add(line);
                }
                line = "";
                continue;
            }
            line = String.valueOf(line) + c;
        }
        ret = ret.subList(1, ret.size());
        logger.debug((Object)("Got prompt, returning: " + ret));
        return ret;
    }

    public void getRootShell() throws IOException, CommandFailedException {
        if (!this.isRootShell()) {
            logger.debug((Object)"Sending su");
            this.stdin.write("su\n");
            this.stdin.flush();
            logger.debug((Object)"Waiting for prompt or root prompt.");
            List<String> line = this.waitForNewPrompt();
            if (!this.isRootShell()) {
                throw new CommandFailedException("su", line, "-1");
            }
            logger.debug((Object)"Got root prompt, returning");
        } else {
            logger.debug((Object)"Already root, returning");
        }
    }
}

