/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.command;

import com.wuntee.oter.command.AbstractCommand;
import com.wuntee.oter.exception.CommandFailedException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class TerminatingCommand
extends AbstractCommand {
    private static Logger logger = Logger.getLogger(TerminatingCommand.class);
    protected List<String> output;
    protected List<String> error;
    private int returnCode;
    private File workingDirectory;

    public TerminatingCommand(String[] command, File workingDirectory) {
        super(command);
        this.workingDirectory = workingDirectory;
    }

    public TerminatingCommand(String command, File workingDirectory) {
        this(new String[]{command}, workingDirectory);
    }

    public TerminatingCommand(String[] command) {
        super(command);
        this.output = new LinkedList<String>();
        this.error = new LinkedList<String>();
    }

    public TerminatingCommand(String command) {
        this(new String[]{command});
    }

    @Override
    public int execute() throws IOException, InterruptedException, CommandFailedException {
        String l;
        if (this.workingDirectory != null) {
            String cmd = "";
            String[] stringArray = this.command;
            int n = this.command.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                cmd = String.valueOf(cmd) + c + " ";
                ++n2;
            }
            logger.debug((Object)("Executing command: " + cmd + " in working directory:" + this.workingDirectory));
            this.child = Runtime.getRuntime().exec(this.command, new String[0], this.workingDirectory);
        } else {
            this.child = Runtime.getRuntime().exec(this.command);
        }
        BufferedReader b = new BufferedReader(new InputStreamReader(this.child.getInputStream()));
        while ((l = b.readLine()) != null) {
            logger.debug((Object)("STDOUT: " + l));
            this.output.add(l);
        }
        this.returnCode = this.child.waitFor();
        logger.debug((Object)("Return code: " + this.returnCode));
        if (this.returnCode != 0) {
            LinkedList<String> ex = new LinkedList<String>();
            ex.addAll(this.output);
            ex.addAll(this.error);
            throw new CommandFailedException(this.command, ex, this.returnCode);
        }
        return this.returnCode;
    }

    public int executeNoErrorMonitor() throws CommandFailedException, InterruptedException, IOException {
        String l;
        this.child = Runtime.getRuntime().exec(this.command);
        BufferedReader b = new BufferedReader(new InputStreamReader(this.child.getInputStream()));
        while ((l = b.readLine()) != null) {
            logger.debug((Object)("STDOUT: " + l));
            this.output.add(l);
        }
        this.returnCode = this.child.waitFor();
        logger.debug((Object)("Return code: " + this.returnCode));
        if (this.returnCode != 0) {
            LinkedList<String> ex = new LinkedList<String>();
            ex.addAll(this.output);
            ex.addAll(this.error);
            throw new CommandFailedException(this.command, ex, this.returnCode);
        }
        return this.returnCode;
    }

    @Override
    public void checkError() {
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public List<String> getOutput() {
        return this.output;
    }

    public void setOutput(List<String> output) {
        this.output = output;
    }

    public List<String> getError() {
        return this.error;
    }

    public void setError(List<String> error) {
        this.error = error;
    }
}

