/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.fs;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class FsNode {
    private static Logger logger = Logger.getLogger(FsNode.class);
    private List<FsNode> children = new LinkedList<FsNode>();
    private FsNode parent;
    private String permissions;
    private String user = "";
    private String group = "";
    private int size;
    private String date = "";
    private String name = "";
    private String link = "";
    private String type = "";
    private String raw = "";
    private String fullPath = "";
    private String root = "";

    public FsNode(String raw, FsNode root) {
        this(raw, root.getName());
    }

    public FsNode(String raw, String root) {
        this.raw = raw;
        this.root = root;
    }

    public void parse() {
        logger.debug((Object)("Parsing:\t" + this.raw));
        this.type = this.raw.substring(0, 1);
        logger.debug((Object)("Type:\t\t" + this.type));
        this.permissions = this.raw.substring(1, 11);
        logger.debug((Object)("Perm:\t\t" + this.permissions));
        String[] split = this.raw.split("\\s+");
        this.user = split[1];
        logger.debug((Object)("User: '" + this.user + "'"));
        this.group = split[2];
        logger.debug((Object)("Group: '" + this.group + "'"));
        if (this.type.equals("-")) {
            this.size = Integer.valueOf(split[3]);
            this.date = String.valueOf(split[4]) + " " + split[5];
            this.name = split[6];
            this.link = "";
        } else if (this.type.equals("d")) {
            this.size = -1;
            this.date = String.valueOf(split[3]) + " " + split[4];
            this.name = split.length > 5 ? split[5] : " ";
            this.link = "";
        } else if (this.type.equals("l")) {
            this.size = -1;
            this.date = String.valueOf(split[3]) + " " + split[4];
            this.name = split[5];
            this.link = split[7];
        } else if (this.type.equals("c")) {
            this.size = -1;
            this.date = String.valueOf(split[5]) + " " + split[6];
            this.name = split[7];
            this.link = "";
        }
        if (!this.root.endsWith("/")) {
            this.root = String.valueOf(this.root) + "/";
        }
        this.fullPath = this.type.equals("d") ? String.valueOf(this.root) + this.name + "/" : String.valueOf(this.root) + this.name;
        logger.debug((Object)("Size: '" + this.size + "'"));
        logger.debug((Object)("Date: '" + this.date + "'"));
        logger.debug((Object)("Name: '" + this.name + "'"));
        logger.debug((Object)("Link: '" + this.link + "'"));
        logger.debug((Object)("root: '" + this.root + "'"));
        logger.debug((Object)("Full: '" + this.fullPath + "'"));
    }

    public boolean equals(Object obj) {
        logger.debug((Object)"Equals?");
        FsNode n = null;
        try {
            n = (FsNode)obj;
        }
        catch (Exception e) {
            logger.debug((Object)"Could not cast to FsNode - not the same.");
            return false;
        }
        logger.debug((Object)"Differences:");
        logger.debug((Object)(String.valueOf(this.fullPath.equals(n.getFullPath())) + " " + this.getFullPath() + " : " + n.getFullPath()));
        logger.debug((Object)(String.valueOf(this.size == n.getSize()) + " " + this.size + " : " + n.getSize()));
        logger.debug((Object)(String.valueOf(this.date.equals(n.getDate())) + " " + this.date + " : " + n.getDate()));
        logger.debug((Object)(String.valueOf(this.link.equals(n.getLink())) + " " + this.link + " : " + n.getLink()));
        if (this.fullPath.equals(n.getFullPath()) && this.size == n.getSize() && this.date.equals(n.getDate()) && this.link.equals(n.getLink())) {
            logger.debug((Object)"Same");
            return true;
        }
        return false;
    }

    public static FsNode getNode(String raw, String root) {
        FsNode ret = new FsNode(raw, root);
        ret.parse();
        return ret;
    }

    public static FsNode getNode(String raw, FsNode root) {
        FsNode ret = new FsNode(raw, root);
        ret.parse();
        return ret;
    }

    public boolean isDirectory() {
        return this.type.equals("d");
    }

    public boolean isLink() {
        return this.type.equals("l");
    }

    public void addChild(FsNode node) {
        this.children.add(node);
    }

    public List<FsNode> getChildren() {
        return this.children;
    }

    public FsNode getParent() {
        return this.parent;
    }

    public void setParent(FsNode parent) {
        this.parent = parent;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRaw() {
        return this.raw;
    }

    public void setRaw(String raw) {
        this.raw = raw;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }
}

