/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.fs;

import com.wuntee.oter.OterStatics;
import com.wuntee.oter.adb.AdbShell;
import com.wuntee.oter.exception.CommandFailedException;
import com.wuntee.oter.fs.FsNode;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class FsWorkshop {
    private static Logger logger = Logger.getLogger(FsNode.class);

    public static List<FsNode> getFilesystem() throws Exception {
        AdbShell shell = new AdbShell();
        shell.execute();
        return FsWorkshop.listDirectoryRecursive("/", shell);
    }

    public static List<FsNode> getDirectoryRecursive(String directory) throws Exception {
        AdbShell shell = new AdbShell();
        shell.execute();
        return FsWorkshop.listDirectoryRecursive(directory, shell);
    }

    private static List<FsNode> listDirectoryRecursive(String root, AdbShell shell) throws IOException, CommandFailedException {
        List<String> lines;
        logger.debug((Object)("listDirectoryRecursive: " + root));
        LinkedList<FsNode> ret = new LinkedList<FsNode>();
        try {
            lines = shell.sendCommand("ls -l " + root);
        }
        catch (CommandFailedException e) {
            return ret;
        }
        for (String line : lines) {
            FsNode node = FsNode.getNode(line, root);
            if (FsWorkshop.isBadDirectory(node.getFullPath())) continue;
            if (node.getType().equals("d")) {
                logger.debug((Object)("Got directory, recursing: " + node.getFullPath()));
                List<FsNode> secRet = FsWorkshop.listDirectoryRecursive(node.getFullPath(), shell);
                for (FsNode sec : secRet) {
                    node.addChild(sec);
                }
            }
            logger.debug((Object)("Adding to return: " + node.getName() + " with children: " + node.getChildren().size()));
            ret.add(node);
        }
        return ret;
    }

    public static boolean isBadDirectory(String dir) {
        logger.debug((Object)("Is bad directory: " + dir));
        String[] stringArray = OterStatics.BAD_DIRECTORIES;
        int n = OterStatics.BAD_DIRECTORIES.length;
        int n2 = 0;
        while (n2 < n) {
            String bad = stringArray[n2];
            if (dir.equals(bad)) {
                logger.debug((Object)"Yes");
                return true;
            }
            ++n2;
        }
        logger.debug((Object)"No");
        return false;
    }
}

