/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.logcat;

import com.wuntee.oter.adb.BackgroundAdbCommand;
import com.wuntee.oter.logcat.LogCatBean;
import com.wuntee.oter.logcat.LogCatLevelEnum;
import java.io.BufferedReader;
import java.io.IOException;
import org.apache.log4j.Logger;

public class LogCatCommand
extends BackgroundAdbCommand {
    private static Logger logger = Logger.getLogger(LogCatBean.class);
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_BLACK = "\u001b[30m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_WHITE = "\u001b[37m";

    public LogCatCommand() {
        super("logcat");
    }

    public static void main(String[] args) throws Exception {
        LogCatCommand lc = new LogCatCommand();
        logger.debug((Object)"Executing command");
        lc.execute();
        BufferedReader read = lc.getStdout();
        BufferedReader error = lc.getStderr();
        logger.debug((Object)"Creating error thread");
        LogCatCommand logCatCommand = lc;
        logCatCommand.getClass();
        ErrorLineReaderThread errorRunnable = logCatCommand.new ErrorLineReaderThread(error);
        Thread errorThread = new Thread(errorRunnable);
        errorThread.start();
        logger.debug((Object)"Creating adb thread");
        LogCatCommand logCatCommand2 = lc;
        logCatCommand2.getClass();
        AdbLineReaderThread readRunnable = logCatCommand2.new AdbLineReaderThread(read);
        Thread readThread = new Thread(readRunnable);
        readThread.start();
        while (true) {
            // Infinite loop
        }
    }

    public class AdbLineReaderThread
    implements Runnable {
        private BufferedReader read;

        public AdbLineReaderThread(BufferedReader read) {
            this.read = read;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            String line = null;
            try {
                while (true) {
                    LogCatBean l;
                    if ((line = this.read.readLine()) == null) {
                        return;
                    }
                    if (line.length() == 0) continue;
                    try {
                        l = LogCatBean.parse(line);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (l.getLevel() == LogCatLevelEnum.DEBUG) {
                        System.out.println(l);
                        continue;
                    }
                    if (l.getLevel() == LogCatLevelEnum.INFO) {
                        System.out.println(l);
                        continue;
                    }
                    if (l.getLevel() == LogCatLevelEnum.WARN) {
                        System.out.println(l);
                        continue;
                    }
                    if (l.getLevel() != LogCatLevelEnum.ERROR) continue;
                    System.out.println(l);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public class ErrorLineReaderThread
    implements Runnable {
        private BufferedReader read;

        public ErrorLineReaderThread(BufferedReader read) {
            this.read = read;
        }

        @Override
        public void run() {
            String line = null;
            try {
                while ((line = this.read.readLine()) != null) {
                    System.err.println("ERROR: " + line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

