/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.smali;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.DSAPrivateKeySpec;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import sun.misc.BASE64Encoder;
import sun.security.util.ManifestDigester;

public class JarSigner15 {
    private static Logger logger = Logger.getLogger(JarSigner15.class);
    private String alias;
    private PrivateKey privateKey;
    private X509Certificate[] certChain;
    private static BASE64Encoder b64Encoder = new BASE64Encoder();

    public JarSigner15(String alias, PrivateKey privateKey, X509Certificate[] certChain) {
        this.alias = alias;
        this.privateKey = privateKey;
        this.certChain = certChain;
    }

    private static Manifest getManifestFile(JarFile jarFile) throws IOException {
        JarEntry je = jarFile.getJarEntry("META-INF/MANIFEST.MF");
        if (je != null) {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                je = entries.nextElement();
                if ("META-INF/MANIFEST.MF".equalsIgnoreCase(je.getName())) break;
                je = null;
            }
        }
        Manifest manifest = new Manifest();
        if (je != null) {
            manifest.read(jarFile.getInputStream(je));
        }
        return manifest;
    }

    private static Map pruneManifest(Manifest manifest, JarFile jarFile) throws IOException {
        Map<String, Attributes> map = manifest.getEntries();
        Iterator<String> elements = map.keySet().iterator();
        while (elements.hasNext()) {
            String element = elements.next();
            if (jarFile.getEntry(element) != null) continue;
            elements.remove();
        }
        return map;
    }

    private static Map createEntries(Manifest manifest, JarFile jarFile) throws IOException {
        Map<String, Attributes> entries = null;
        if (manifest.getEntries().size() > 0) {
            entries = JarSigner15.pruneManifest(manifest, jarFile);
        } else {
            Attributes attributes = manifest.getMainAttributes();
            attributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
            attributes.putValue("Created-By", String.valueOf(System.getProperty("java.version")) + " (" + System.getProperty("java.vendor") + ")");
            entries = manifest.getEntries();
        }
        return entries;
    }

    private static String updateDigest(MessageDigest digest, InputStream inputStream) throws IOException {
        byte[] buffer = new byte[2048];
        int read = 0;
        while ((read = inputStream.read(buffer)) > 0) {
            digest.update(buffer, 0, read);
        }
        inputStream.close();
        return b64Encoder.encode(digest.digest());
    }

    private static Map updateManifestDigest(Manifest manifest, JarFile jarFile, MessageDigest messageDigest, Map entries) throws IOException {
        Enumeration<JarEntry> jarElements = jarFile.entries();
        while (jarElements.hasMoreElements()) {
            Attributes attributes;
            JarEntry jarEntry = jarElements.nextElement();
            if (jarEntry.getName().startsWith("META-INF")) continue;
            if (manifest.getAttributes(jarEntry.getName()) != null) {
                attributes = manifest.getAttributes(jarEntry.getName());
                attributes.putValue("SHA1-Digest", JarSigner15.updateDigest(messageDigest, jarFile.getInputStream(jarEntry)));
                continue;
            }
            if (jarEntry.isDirectory()) continue;
            attributes = new Attributes();
            attributes.putValue("SHA1-Digest", JarSigner15.updateDigest(messageDigest, jarFile.getInputStream(jarEntry)));
            entries.put(jarEntry.getName(), attributes);
        }
        return entries;
    }

    private byte[] serialiseManifest(Manifest manifest) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        manifest.write(baos);
        baos.flush();
        baos.close();
        return baos.toByteArray();
    }

    private SignatureFile createSignatureFile(Manifest manifest, MessageDigest messageDigest) throws IOException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        ManifestDigester manifestDigester = new ManifestDigester(this.serialiseManifest(manifest));
        return new SignatureFile(new MessageDigest[]{messageDigest}, manifest, manifestDigester, this.alias, true);
    }

    private static void writeJarEntry(JarEntry je, JarFile jarFile, JarOutputStream jos) throws IOException {
        jos.putNextEntry(je);
        byte[] buffer = new byte[2048];
        int read = 0;
        InputStream is = jarFile.getInputStream(je);
        while ((read = is.read(buffer)) > 0) {
            jos.write(buffer, 0, read);
        }
        jos.closeEntry();
    }

    public void signJarFile(JarFile jarFile, OutputStream outputStream) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, IOException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, CertificateException, InstantiationException, ClassNotFoundException {
        Manifest manifest = JarSigner15.getManifestFile(jarFile);
        Map entries = JarSigner15.createEntries(manifest, jarFile);
        MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
        JarSigner15.updateManifestDigest(manifest, jarFile, messageDigest, entries);
        SignatureFile signatureFile = this.createSignatureFile(manifest, messageDigest);
        SignatureFile.Block block = signatureFile.generateBlock(this.privateKey, this.certChain, true, jarFile);
        String manifestFileName = "META-INF/MANIFEST.MF";
        JarOutputStream jos = new JarOutputStream(outputStream);
        JarEntry manifestFile = new JarEntry(manifestFileName);
        jos.putNextEntry(manifestFile);
        byte[] manifestBytes = this.serialiseManifest(manifest);
        jos.write(manifestBytes, 0, manifestBytes.length);
        jos.closeEntry();
        String signatureFileName = signatureFile.getMetaName();
        JarEntry signatureFileEntry = new JarEntry(signatureFileName);
        jos.putNextEntry(signatureFileEntry);
        signatureFile.write(jos);
        jos.closeEntry();
        String signatureBlockName = block.getMetaName();
        JarEntry signatureBlockEntry = new JarEntry(signatureBlockName);
        jos.putNextEntry(signatureBlockEntry);
        block.write(jos);
        jos.closeEntry();
        Enumeration<JarEntry> metaEntries = jarFile.entries();
        while (metaEntries.hasMoreElements()) {
            JarEntry metaEntry = metaEntries.nextElement();
            if (!metaEntry.getName().startsWith("META-INF") || manifestFileName.equalsIgnoreCase(metaEntry.getName()) || signatureFileName.equalsIgnoreCase(metaEntry.getName()) || signatureBlockName.equalsIgnoreCase(metaEntry.getName())) continue;
            JarSigner15.writeJarEntry(metaEntry, jarFile, jos);
        }
        Enumeration<JarEntry> allEntries = jarFile.entries();
        while (allEntries.hasMoreElements()) {
            JarEntry entry = allEntries.nextElement();
            if (entry.getName().startsWith("META-INF")) continue;
            JarSigner15.writeJarEntry(entry, jarFile, jos);
        }
        jos.flush();
        jos.finish();
        jarFile.close();
    }

    private static Constructor findConstructor(Class c, Class ... argTypes) throws NoSuchMethodException {
        Constructor ct = c.getDeclaredConstructor(argTypes);
        if (ct == null) {
            throw new RuntimeException(c.getName());
        }
        ct.setAccessible(true);
        return ct;
    }

    private static Method findMethod(Class c, String methodName, Class ... argTypes) throws NoSuchMethodException {
        Method m = c.getDeclaredMethod(methodName, argTypes);
        if (m == null) {
            throw new RuntimeException(c.getName());
        }
        m.setAccessible(true);
        return m;
    }

    public static File sign(File jar, String newName, String keystoreLocation, String alias, char[] passwd, char[] keypasswd) throws Exception {
        FileInputStream fileIn = new FileInputStream(keystoreLocation);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(fileIn, passwd);
        Certificate[] chain = keyStore.getCertificateChain(alias);
        X509Certificate[] certChain = new X509Certificate[chain.length];
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        int count = 0;
        while (count < chain.length) {
            X509Certificate cert;
            ByteArrayInputStream certIn = new ByteArrayInputStream(chain[0].getEncoded());
            certChain[count] = cert = (X509Certificate)cf.generateCertificate(certIn);
            ++count;
        }
        Key key = keyStore.getKey(alias, keypasswd);
        logger.debug((Object)("Algo: " + key.getAlgorithm()));
        KeyFactory keyFactory = KeyFactory.getInstance(key.getAlgorithm());
        DSAPrivateKeySpec keySpec = keyFactory.getKeySpec(key, DSAPrivateKeySpec.class);
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        JarSigner15 jarSigner = new JarSigner15(alias, privateKey, certChain);
        JarFile jarFile = new JarFile(jar.getCanonicalPath());
        File newJar = new File(jar.getParentFile(), newName);
        FileOutputStream outStream = new FileOutputStream(newJar);
        jarSigner.signJarFile(jarFile, outStream);
        fileIn.close();
        return newJar;
    }

    public static File sign(File jar, String keystoreLocation, String alias, char[] passwd, char[] keypasswd) throws Exception {
        return JarSigner15.sign(jar, "s-" + jar.getName(), keystoreLocation, alias, passwd, keypasswd);
    }

    private class SignatureFile {
        private Object sigFile;
        private Class JDKsfClass;
        private Method getMetaNameMethod;
        private Method writeMethod;
        private static final String JDK_SIGNATURE_FILE = "sun.security.tools.SignatureFile";
        private static final String GETMETANAME_METHOD = "getMetaName";
        private static final String WRITE_METHOD = "write";

        public SignatureFile(MessageDigest[] digests, Manifest mf, ManifestDigester md, String baseName, boolean signManifest) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
            this.getClass();
            this.JDKsfClass = Class.forName(JDK_SIGNATURE_FILE);
            Constructor constructor = JarSigner15.findConstructor(this.JDKsfClass, new Class[]{MessageDigest[].class, Manifest.class, ManifestDigester.class, String.class, Boolean.TYPE});
            this.sigFile = constructor.newInstance(digests, mf, md, baseName, signManifest);
            this.getMetaNameMethod = JarSigner15.findMethod(this.JDKsfClass, GETMETANAME_METHOD, new Class[0]);
            this.writeMethod = JarSigner15.findMethod(this.JDKsfClass, WRITE_METHOD, new Class[]{OutputStream.class});
        }

        public Block generateBlock(PrivateKey privateKey, X509Certificate[] certChain, boolean externalSF, ZipFile zipFile) throws NoSuchAlgorithmException, InvalidKeyException, IOException, SignatureException, CertificateException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
            return new Block(this, privateKey, certChain, externalSF, zipFile);
        }

        public Class getJDKSignatureFileClass() {
            return this.JDKsfClass;
        }

        public Object getJDKSignatureFile() {
            return this.sigFile;
        }

        public String getMetaName() throws IllegalAccessException, InvocationTargetException {
            return (String)this.getMetaNameMethod.invoke(this.sigFile, new Object[0]);
        }

        public void write(OutputStream os) throws IllegalAccessException, InvocationTargetException {
            this.writeMethod.invoke(this.sigFile, os);
        }

        private class Block {
            private Object block;
            private static final String JDK_BLOCK = "sun.security.tools.SignatureFile$Block";
            private static final String JDK_CONTENT_SIGNER = "com.sun.jarsigner.ContentSigner";
            private Method getMetaNameMethod;
            private Method writeMethod;

            public Block(SignatureFile sfg, PrivateKey privateKey, X509Certificate[] certChain, boolean externalSF, ZipFile zipFile) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
                this.getClass();
                Class<?> blockClass = Class.forName(JDK_BLOCK);
                this.getClass();
                Class<?> contentSignerClass = Class.forName(JDK_CONTENT_SIGNER);
                Constructor constructor = JarSigner15.findConstructor(blockClass, new Class[]{sfg.getJDKSignatureFileClass(), PrivateKey.class, X509Certificate[].class, Boolean.TYPE, String.class, X509Certificate.class, contentSignerClass, String[].class, ZipFile.class});
                this.getMetaNameMethod = JarSigner15.findMethod(blockClass, SignatureFile.GETMETANAME_METHOD, new Class[0]);
                this.writeMethod = JarSigner15.findMethod(blockClass, SignatureFile.WRITE_METHOD, new Class[]{OutputStream.class});
                this.block = constructor.newInstance(sfg.getJDKSignatureFile(), privateKey, certChain, externalSF, null, null, null, null, zipFile);
            }

            public String getMetaName() throws IllegalAccessException, InvocationTargetException {
                return (String)this.getMetaNameMethod.invoke(this.block, new Object[0]);
            }

            public void write(OutputStream os) throws IllegalAccessException, InvocationTargetException {
                this.writeMethod.invoke(this.block, os);
            }
        }
    }
}

