/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.view;

import com.wuntee.oter.OterStatics;
import com.wuntee.oter.OterWorkshop;
import com.wuntee.oter.adb.AdbWorkshop;
import com.wuntee.oter.view.GuiWorkshop;
import java.io.FileOutputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConfigurationDialog
extends Dialog {
    private static Logger logger = Logger.getLogger(ConfigurationDialog.class);
    protected Object result;
    protected Shell shell;
    private Text androidHomeText;
    private List javaToSmaliClasspath;
    private Text maxLogcatLinesText;
    private List devicesList;

    public ConfigurationDialog(Shell parent) {
        this(parent, 67680);
    }

    public ConfigurationDialog(Shell parent, int style) {
        super(parent, style);
        this.setText("Configuration");
    }

    public Object open() {
        this.createContents();
        this.loadConfig();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void loadConfig() {
        String device;
        for (String d : AdbWorkshop.getDeviceList()) {
            this.devicesList.add(d);
        }
        this.androidHomeText.setText(OterWorkshop.getProperty(OterStatics.PROPERTY_ANDROID_HOME) == null ? "" : OterWorkshop.getProperty(OterStatics.PROPERTY_ANDROID_HOME));
        this.maxLogcatLinesText.setText(OterWorkshop.getProperty(OterStatics.PROPERTY_LOGCAT_MAXLINES));
        String javaToSmaliClasspathString = OterWorkshop.getProperty(OterStatics.PROPERTY_JAVATOSMALI_CLASSPATH);
        if (javaToSmaliClasspathString != null) {
            String[] stringArray = javaToSmaliClasspathString.split(":");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!s.trim().equals("")) {
                    this.javaToSmaliClasspath.add(s);
                }
                ++n2;
            }
        }
        if ((device = OterWorkshop.getProperty(OterStatics.PROPERTY_DEVICE)) != null) {
            int i = 0;
            while (i < this.devicesList.getItemCount()) {
                if (this.devicesList.getItem(i).equals(device)) {
                    this.devicesList.select(i);
                }
                ++i;
            }
        }
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 2160);
        this.shell.setMinimumSize(new Point(450, 420));
        this.shell.setSize(450, 420);
        this.shell.setText("Configuration");
        GridLayout gl_shell = new GridLayout(1, false);
        gl_shell.verticalSpacing = 0;
        gl_shell.marginWidth = 0;
        gl_shell.marginTop = 5;
        gl_shell.marginRight = 5;
        gl_shell.marginBottom = 5;
        gl_shell.marginLeft = 5;
        gl_shell.marginHeight = 0;
        gl_shell.horizontalSpacing = 0;
        this.shell.setLayout((Layout)gl_shell);
        Composite composite_4 = new Composite((Composite)this.shell, 0);
        composite_4.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout gl_composite_4 = new GridLayout(1, false);
        gl_composite_4.verticalSpacing = 0;
        gl_composite_4.marginWidth = 0;
        gl_composite_4.marginHeight = 0;
        gl_composite_4.horizontalSpacing = 0;
        composite_4.setLayout((Layout)gl_composite_4);
        Label lblAndroidHome = new Label(composite_4, 32);
        lblAndroidHome.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblAndroidHome.setBounds(0, 0, 124, 14);
        lblAndroidHome.setText("Android SDK Location:");
        Composite composite = new Composite(composite_4, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, true, 1, 1));
        composite.setBounds(0, 0, 440, 28);
        GridLayout gl_composite = new GridLayout(2, false);
        gl_composite.horizontalSpacing = 0;
        gl_composite.marginHeight = 0;
        gl_composite.marginWidth = 0;
        gl_composite.verticalSpacing = 0;
        composite.setLayout((Layout)gl_composite);
        this.androidHomeText = new Text(composite, 2048);
        this.androidHomeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.androidHomeText.setBounds(0, 0, 64, 19);
        Button btnNewButton = new Button(composite, 0);
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String dir = GuiWorkshop.selectDirectory(ConfigurationDialog.this.shell);
                if (dir != null) {
                    ConfigurationDialog.this.androidHomeText.setText(dir);
                }
            }
        });
        btnNewButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        btnNewButton.setBounds(0, 0, 94, 30);
        btnNewButton.setText("Search");
        Composite composite_5 = new Composite((Composite)this.shell, 0);
        GridLayout gl_composite_5 = new GridLayout(2, false);
        gl_composite_5.verticalSpacing = 0;
        gl_composite_5.marginWidth = 0;
        gl_composite_5.horizontalSpacing = 0;
        gl_composite_5.marginHeight = 0;
        composite_5.setLayout((Layout)gl_composite_5);
        composite_5.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblMaxLogcatLines = new Label(composite_5, 0);
        lblMaxLogcatLines.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblMaxLogcatLines.setBounds(0, 0, 59, 14);
        lblMaxLogcatLines.setText("Max LogCat lines:");
        this.maxLogcatLinesText = new Text(composite_5, 2048);
        GridData gd_maxLogcatLinesText = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_maxLogcatLinesText.widthHint = 100;
        this.maxLogcatLinesText.setLayoutData((Object)gd_maxLogcatLinesText);
        this.maxLogcatLinesText.setBounds(0, 0, 64, 19);
        Composite composite_2 = new Composite((Composite)this.shell, 0);
        GridLayout gl_composite_2 = new GridLayout(1, false);
        gl_composite_2.marginTop = 5;
        gl_composite_2.verticalSpacing = 0;
        gl_composite_2.marginWidth = 0;
        gl_composite_2.marginHeight = 0;
        gl_composite_2.horizontalSpacing = 0;
        composite_2.setLayout((Layout)gl_composite_2);
        composite_2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblJavaToSmali = new Label(composite_2, 0);
        lblJavaToSmali.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblJavaToSmali.setText("Java to Smali Classpath:");
        this.javaToSmaliClasspath = new List(composite_2, 2816);
        GridData gd_javaToSmaliClasspath = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_javaToSmaliClasspath.heightHint = 100;
        this.javaToSmaliClasspath.setLayoutData((Object)gd_javaToSmaliClasspath);
        Composite composite_3 = new Composite(composite_2, 0);
        GridLayout gl_composite_3 = new GridLayout(2, false);
        gl_composite_3.horizontalSpacing = 0;
        gl_composite_3.marginHeight = 0;
        gl_composite_3.marginWidth = 0;
        gl_composite_3.verticalSpacing = 0;
        composite_3.setLayout((Layout)gl_composite_3);
        composite_3.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnAdd = new Button(composite_3, 0);
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String fileName = GuiWorkshop.selectFile(ConfigurationDialog.this.shell, new String[]{"*.jar"});
                if (fileName != null) {
                    ConfigurationDialog.this.javaToSmaliClasspath.add(fileName);
                }
            }
        });
        btnAdd.setText("Add");
        Button btnRemove = new Button(composite_3, 0);
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ConfigurationDialog.this.javaToSmaliClasspath.remove(ConfigurationDialog.this.javaToSmaliClasspath.getSelectionIndex());
            }
        });
        btnRemove.setText("Remove");
        Composite composite_6 = new Composite((Composite)this.shell, 0);
        GridLayout gl_composite_6 = new GridLayout(1, false);
        gl_composite_6.verticalSpacing = 0;
        gl_composite_6.marginWidth = 0;
        gl_composite_6.marginHeight = 0;
        gl_composite_6.horizontalSpacing = 0;
        composite_6.setLayout((Layout)gl_composite_6);
        composite_6.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblDevice = new Label(composite_6, 0);
        lblDevice.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        lblDevice.setBounds(0, 0, 59, 14);
        lblDevice.setText("Device:");
        this.devicesList = new List(composite_6, 2816);
        GridData gd_list = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_list.heightHint = 75;
        this.devicesList.setLayoutData((Object)gd_list);
        this.devicesList.setBounds(0, 0, 3, 66);
        Composite composite_1 = new Composite((Composite)this.shell, 0);
        composite_1.setLayoutData((Object)new GridData(131072, 1024, false, true, 1, 1));
        composite_1.setBounds(0, 0, 64, 64);
        GridLayout gl_composite_1 = new GridLayout(2, false);
        gl_composite_1.horizontalSpacing = 0;
        gl_composite_1.marginHeight = 0;
        gl_composite_1.marginWidth = 0;
        gl_composite_1.verticalSpacing = 0;
        composite_1.setLayout((Layout)gl_composite_1);
        Button btnSave = new Button(composite_1, 0);
        btnSave.setLayoutData((Object)new GridData(16384, 1024, false, false, 1, 1));
        btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String configFile = OterStatics.getConfigFileName();
                Properties prop = new Properties();
                prop.setProperty(OterStatics.PROPERTY_ANDROID_HOME, ConfigurationDialog.this.androidHomeText.getText());
                String cp = StringUtils.join((Object[])ConfigurationDialog.this.javaToSmaliClasspath.getItems(), (String)":");
                prop.setProperty(OterStatics.PROPERTY_JAVATOSMALI_CLASSPATH, cp);
                String max = ConfigurationDialog.this.maxLogcatLinesText.getText();
                prop.setProperty(OterStatics.PROPERTY_LOGCAT_MAXLINES, max);
                String[] devices = ConfigurationDialog.this.devicesList.getSelection();
                if (devices.length > 0) {
                    prop.setProperty(OterStatics.PROPERTY_DEVICE, devices[0]);
                }
                try {
                    prop.store(new FileOutputStream(configFile), null);
                }
                catch (Exception e) {
                    GuiWorkshop.messageError(ConfigurationDialog.this.shell, "Could not save configuration file(" + configFile + "): " + e.getMessage());
                    logger.error((Object)"Could not save config: ", (Throwable)e);
                }
                ConfigurationDialog.this.shell.close();
            }
        });
        btnSave.setText("Save");
        Button btnCancel = new Button(composite_1, 0);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ConfigurationDialog.this.shell.close();
            }
        });
        btnCancel.setText("Cancel");
    }
}

