/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.view;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.SdkManager;
import com.wuntee.oter.OterStatics;
import com.wuntee.oter.avd.AvdWorkshop;
import com.wuntee.oter.view.GuiWorkshop;
import com.wuntee.oter.view.bean.CreateAvdBean;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateAvdDialog
extends Dialog {
    private static Logger logger = Logger.getLogger(CreateAvdDialog.class);
    protected CreateAvdBean result;
    protected Shell shell;
    private Text text;
    private Button btnPersistantStorage;
    private Button btnLaunchAvdAfter;
    private Combo combo;
    private Composite composite;

    public CreateAvdDialog(Shell parent) {
        this(parent, 67680);
    }

    public CreateAvdDialog(Shell parent, int style) {
        super(parent, style);
        this.setText("Create Android Virtual Device");
    }

    public CreateAvdBean open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), this.getStyle());
        this.shell.setSize(335, 236);
        this.shell.setText(this.getText());
        GridLayout gl_shell = new GridLayout(1, false);
        gl_shell.marginRight = 5;
        gl_shell.marginLeft = 5;
        gl_shell.marginTop = 5;
        gl_shell.verticalSpacing = 0;
        gl_shell.marginWidth = 0;
        gl_shell.horizontalSpacing = 0;
        gl_shell.marginHeight = 0;
        this.shell.setLayout((Layout)gl_shell);
        Label lblName = new Label((Composite)this.shell, 0);
        lblName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblName.setText("Name:");
        this.text = new Text((Composite)this.shell, 2048);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        new Label((Composite)this.shell, 0);
        Label lblTarget = new Label((Composite)this.shell, 0);
        lblTarget.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblTarget.setText("Target:");
        this.combo = new Combo((Composite)this.shell, 8);
        this.combo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.addTargets(this.combo);
        new Label((Composite)this.shell, 0);
        this.btnPersistantStorage = new Button((Composite)this.shell, 32);
        this.btnPersistantStorage.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.btnPersistantStorage.setText("Persistant system storage");
        this.btnLaunchAvdAfter = new Button((Composite)this.shell, 32);
        this.btnLaunchAvdAfter.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.btnLaunchAvdAfter.setText("Launch AVD after creation");
        new Label((Composite)this.shell, 0);
        this.composite = new Composite((Composite)this.shell, 0);
        GridLayout gl_composite = new GridLayout(2, false);
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        gl_composite.horizontalSpacing = 0;
        gl_composite.verticalSpacing = 0;
        this.composite.setLayout((Layout)gl_composite);
        this.composite.setLayoutData((Object)new GridData(131072, 1024, true, true, 1, 1));
        Button btnCreateAvd = new Button(this.composite, 0);
        btnCreateAvd.setLayoutData((Object)new GridData(4, 0x1000000, false, true, 1, 1));
        btnCreateAvd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                boolean exists = false;
                try {
                    exists = AvdWorkshop.isAvdExist(CreateAvdDialog.this.text.getText());
                }
                catch (AndroidLocation.AndroidLocationException e) {
                    logger.error((Object)"Problem getting avds: ", (Throwable)e);
                }
                if (CreateAvdDialog.this.text.getText().trim().equals("") || CreateAvdDialog.this.combo.getText().trim().equals("")) {
                    GuiWorkshop.messageError(CreateAvdDialog.this.shell, "Please set a name, and select a target.");
                } else if (exists) {
                    GuiWorkshop.messageError(CreateAvdDialog.this.shell, "There is already and AVD with that name, please use a name that does not already exist.");
                } else {
                    CreateAvdDialog.this.result = new CreateAvdBean();
                    CreateAvdDialog.this.result.setName(CreateAvdDialog.this.text.getText());
                    CreateAvdDialog.this.result.setPersistant(CreateAvdDialog.this.btnPersistantStorage.getSelection());
                    CreateAvdDialog.this.result.setTarget(CreateAvdDialog.this.combo.getText());
                    CreateAvdDialog.this.result.setLaunch(CreateAvdDialog.this.btnLaunchAvdAfter.getSelection());
                    CreateAvdDialog.this.shell.close();
                }
            }
        });
        btnCreateAvd.setText("Create AVD");
        Button btnCancel = new Button(this.composite, 0);
        btnCancel.setLayoutData((Object)new GridData(16384, 0x1000000, false, true, 1, 1));
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                CreateAvdDialog.this.shell.close();
            }
        });
        btnCancel.setText("Cancel");
    }

    private void addTargets(Combo combo) {
        IAndroidTarget[] targets;
        ISdkLog sdkLogger = new ISdkLog(){

            public void error(Throwable t, String errorFormat, Object[] args) {
                logger.error((Object)"Error: ", t);
            }

            public void warning(String warningFormat, Object[] args) {
                logger.warn((Object)args);
            }

            public void printf(String msgFormat, Object[] args) {
                logger.debug((Object)args);
            }
        };
        SdkManager sdkManager = SdkManager.createManager((String)OterStatics.getAndroidHome(), (ISdkLog)sdkLogger);
        IAndroidTarget[] iAndroidTargetArray = targets = sdkManager.getTargets();
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            IAndroidTarget target = iAndroidTargetArray[n2];
            combo.add(target.hashString());
            ++n2;
        }
    }
}

