/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.view;

import org.apache.log4j.Logger;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FindDialog
extends Dialog {
    private static Logger logger = Logger.getLogger(FindDialog.class);
    protected Object result;
    protected Shell shlFind;
    private Text searchText;
    private StyledText searchContext;
    private Button btnIgnoreCase;

    public FindDialog(Shell parent, StyledText searchContext) {
        this(parent, 67680, searchContext);
    }

    public FindDialog(Shell parent, int style, StyledText searchContext) {
        super(parent, style);
        this.setText("Search");
        this.searchContext = searchContext;
    }

    private void findNext() {
        String search = this.searchText.getText();
        logger.debug((Object)("Searching for: " + search));
        Point p = this.searchContext.getSelectionRange();
        String rest = this.searchContext.getTextRange(p.x + p.y, this.searchContext.getText().length() - (p.x + p.y));
        int x = rest.indexOf(search);
        if (x != -1) {
            x = p.x + p.y + x;
            int y = x + search.length();
            this.searchContext.setSelection(x, y);
        } else if (p.x != 0 && p.y != 0) {
            this.searchContext.setSelection(0, 0);
            this.findNext();
        }
    }

    private void findPrevious() {
        String search = this.searchText.getText();
        logger.debug((Object)("Searching for: " + search));
        Point p = this.searchContext.getSelectionRange();
        String rest = this.searchContext.getTextRange(0, p.x);
        int x = rest.lastIndexOf(search);
        if (x != -1) {
            int y = x + search.length();
            this.searchContext.setSelection(x, y);
        } else if (p.x != this.searchContext.getText().length() && p.y != 0) {
            this.searchContext.setSelection(this.searchContext.getText().length(), this.searchContext.getText().length());
            this.findPrevious();
        }
    }

    public Object open() {
        this.createContents();
        this.shlFind.open();
        this.shlFind.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shlFind.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        this.shlFind = new Shell(this.getParent(), 2144);
        this.shlFind.setSize(450, 128);
        this.shlFind.setText("Find");
        GridLayout gl_shlFind = new GridLayout(1, false);
        gl_shlFind.verticalSpacing = 0;
        gl_shlFind.marginWidth = 0;
        gl_shlFind.marginBottom = 5;
        gl_shlFind.marginTop = 5;
        gl_shlFind.marginRight = 5;
        gl_shlFind.marginLeft = 5;
        gl_shlFind.marginHeight = 0;
        gl_shlFind.horizontalSpacing = 0;
        this.shlFind.setLayout((Layout)gl_shlFind);
        Label lblSearchString = new Label((Composite)this.shlFind, 0);
        lblSearchString.setBounds(0, 0, 59, 14);
        lblSearchString.setText("Search String:");
        this.searchText = new Text((Composite)this.shlFind, 2048);
        this.searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent arg0) {
                if (arg0.character == '\r') {
                    FindDialog.this.findNext();
                }
            }
        });
        this.searchText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnIgnoreCase = new Button((Composite)this.shlFind, 32);
        this.btnIgnoreCase.setText("Ignore Case");
        Composite composite = new Composite((Composite)this.shlFind, 0);
        composite.setLayoutData((Object)new GridData(131072, 1024, false, true, 1, 1));
        GridLayout gl_composite = new GridLayout(3, false);
        gl_composite.horizontalSpacing = 0;
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        gl_composite.verticalSpacing = 0;
        composite.setLayout((Layout)gl_composite);
        Button btnPrevious = new Button(composite, 0);
        btnPrevious.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FindDialog.this.findPrevious();
            }
        });
        btnPrevious.setText("Previous");
        Button btnNext = new Button(composite, 0);
        btnNext.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FindDialog.this.findNext();
            }
        });
        btnNext.setText("Next");
        Button btnCancel = new Button(composite, 0);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FindDialog.this.shlFind.close();
            }
        });
        btnCancel.setBounds(0, 0, 94, 30);
        btnCancel.setText("Cancel");
    }
}

