/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.view.widgets;

import com.wuntee.oter.adb.AdbWorkshop;
import com.wuntee.oter.packagemanager.PackageBean;
import com.wuntee.oter.view.GuiWorkshop;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ApkTable {
    private static Logger logger = Logger.getLogger(ApkTable.class);
    private Table table;

    public ApkTable(Composite parent) {
        this(parent, 67584);
    }

    public ApkTable(Composite parent, int style) {
        this.table = new Table(parent, style);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.setBounds(0, 0, 3, 19);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn tblclmnApk = new TableColumn(this.table, 0);
        tblclmnApk.setWidth(200);
        tblclmnApk.setText("APK");
        TableColumn tblclmnPackage = new TableColumn(this.table, 0);
        tblclmnPackage.setWidth(300);
        tblclmnPackage.setText("Package");
        String[] keys = new String[]{PackageBean.class.getName()};
        GuiWorkshop.addColumnSorter(this.table, tblclmnApk, 0, keys);
        GuiWorkshop.addColumnSorter(this.table, tblclmnPackage, 1, keys);
    }

    public void loadPackages() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    List<PackageBean> packageBeans = AdbWorkshop.listPackages();
                    ApkTable.this.loadPackagesGui(packageBeans);
                }
                catch (Exception e) {
                    logger.error((Object)"Error loading packages:", (Throwable)e);
                }
            }
        }).start();
    }

    private void loadPackagesGui(List<PackageBean> packages) {
        this.table.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ApkTable.this.table.removeAll();
                try {
                    List<PackageBean> beans = AdbWorkshop.listPackages();
                    for (PackageBean bean : beans) {
                        String apk = bean.getApk().substring(bean.getApk().lastIndexOf(47) + 1, bean.getApk().length());
                        TableItem tableItem = new TableItem(ApkTable.this.table, 0);
                        tableItem.setText(new String[]{apk, bean.getClazz()});
                        tableItem.setData(PackageBean.class.getName(), (Object)bean);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Error loading packages:", (Throwable)e);
                    GuiWorkshop.messageError(ApkTable.this.table.getShell(), "There was an error loading the packages: " + e.getMessage());
                }
            }
        });
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }
}

