/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.util.PerfLogger;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.BrowserSupport;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jnlp.BasicService;
import sun.awt.DesktopBrowse;

public final class BasicServiceImpl
implements BasicService {
    private URL _codebase = null;
    private String _codebaseProtocol = null;
    private boolean _isWebBrowserSupported;
    private static BasicServiceImpl _sharedInstance = null;

    private BasicServiceImpl(URL uRL, boolean bl, String string) {
        this._codebaseProtocol = string;
        this._codebase = uRL;
        this._isWebBrowserSupported = bl;
        if (Config.isJavaVersionAtLeast16() && DesktopBrowse.getInstance() == null) {
            try {
                DesktopBrowse.setInstance((DesktopBrowse)new BasicServiceBrowser());
            }
            catch (Throwable throwable) {
                Trace.ignored((Throwable)throwable);
            }
        }
    }

    public static BasicServiceImpl getInstance() {
        return _sharedInstance;
    }

    public static void initialize(URL uRL, boolean bl, String string) {
        if (_sharedInstance == null) {
            _sharedInstance = new BasicServiceImpl(uRL, bl, string);
        }
    }

    public URL getCodeBase() {
        return this._codebase;
    }

    public boolean isOffline() {
        return DeployOfflineManager.isGlobalOffline();
    }

    private boolean isFileProtocolCodebase() {
        return this._codebaseProtocol != null && this._codebaseProtocol.equalsIgnoreCase("file");
    }

    public boolean showDocument(URL uRL) {
        DesktopBrowse desktopBrowse;
        if (uRL == null) {
            return false;
        }
        if (!URLUtil.checkTargetURL((URL)this._codebase, (URL)uRL)) {
            throw new SecurityException("ShowDocument url permission denied");
        }
        if (Config.isJavaVersionAtLeast16() && (desktopBrowse = DesktopBrowse.getInstance()) != null && !(desktopBrowse instanceof BasicServiceBrowser)) {
            if (!this.isWebBrowserSupported()) {
                return false;
            }
            try {
                uRL = new URL(this._codebase, uRL.toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            desktopBrowse.browse(uRL);
            return true;
        }
        return this.showDocumentHelper(uRL);
    }

    private boolean showDocumentHelper(final URL uRL) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (DownloadEngine.isJnlpURL((URL)uRL)) {
                    try {
                        String string = DownloadEngine.getCachedResourceFilePath((URL)uRL, null);
                        if (string != null) {
                            String[] stringArray = new String[]{Config.getJavawsCommand(), "-Xnosplash", string};
                            Runtime.getRuntime().exec(stringArray);
                            return new Boolean(true);
                        }
                    }
                    catch (Exception exception) {
                        Trace.ignored((Throwable)exception);
                    }
                }
                return new Boolean(false);
            }
        });
        if (bl != null && bl.booleanValue()) {
            return true;
        }
        if (!this.isWebBrowserSupported()) {
            return false;
        }
        bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL uRL3 = uRL;
                try {
                    URL uRL2;
                    uRL3 = uRL2 = new URL(BasicServiceImpl.this._codebase, uRL3.toString());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                return new Boolean(BrowserSupport.showDocument(uRL3));
            }
        });
        return bl == null ? false : bl;
    }

    public boolean isWebBrowserSupported() {
        PerfLogger.setEndTime((String)"BasicService.isWebBrowserSupported called");
        PerfLogger.outputLog();
        return this._isWebBrowserSupported;
    }

    private class BasicServiceBrowser
    extends DesktopBrowse {
        private BasicServiceBrowser() {
        }

        public void browse(URL uRL) {
            BasicServiceImpl.this.showDocument(uRL);
        }
    }
}

