#import "AbstractConnection.h"
#import "ncftp.h"

@class FTPParser;
@class FTPMLSxParser;

typedef int FTPListType;
enum
{
	kListTypeUnknown = 0,
	
// in order of preference:
	kListTypeLIST_a,
	kListTypeLIST_al,
	kListTypeLIST,
	kListTypeNLST,
	
	kListTypeCount
};


@interface FTPConnection : AbstractConnection
{
@private
	FTPConnectionInfo	ci;
	int 				connectCallDepth;
	FTPLineList			connectMsg;
	FTPLineList			loginMsg;
	NSString*			iLastServerMessage;
	BOOL				useTLS;
	BOOL				useSSL;
	FTPListType			iListType;
	NSDate*				iLastKeepAliveDate;
	unsigned int		numKeepAlives;
	FTPParser* iParser;
	NSTimeZone* iTimeZoneGuess;
	FTPMLSxParser* iMLSxParser;
	int	iTransferMode;
	
	NSCalendar			*iCalendar;
}

@property FTPListType listType;
@property int transferMode;

- (BOOL)FXPUploadFileAtPath:(NSString*)sourcePath toPath:(NSString*)destinationPath destinationConnection:(FTPConnection*)destinationConnection error:(FTPKitError**)error;
- (int)sendPassive:(FTPKitError**)error;

// Private
- (void)appendTranscript:(NSString*)transcriptChunk;
- (void)updateProgress:(int)state;
- (void)throttleDownloadTransfer;
- (void)throttleUploadTransfer;
- (void)setConnectMsg:(FTPLineListPtr)msg;
- (void)setLastResponseMsg:(FTPLineListPtr)msg;

@end
