#import <Foundation/Foundation.h>
#import "FTPKitConstants.h"

@class PCNode;

@interface FTPKitError : NSError 
{
	PCNode *iNode; // not coded/decoded
	BOOL iCanBeContinued;
	
	NSArray *iPreviousErrors;
	
	NSString *iDefaultButtonTitle;
	NSString *iAlternateButtonTitle;	
}

@property (retain, readwrite) PCNode *node;
@property (assign, readwrite) BOOL canBeContinued;
@property (copy, readwrite) NSArray *previousErrors;
@property (copy, readwrite) NSString *defaultButtonTitle;
@property (copy, readwrite) NSString *alternateButtonTitle;

+ (FTPKitError*)errorWithTitle:(NSString*)title message:(NSString*)message kitError:(FTPKitErrorCode)code;
+ (FTPKitError*)errorWithTitle:(NSString*)title message:(NSString*)message kitError:(FTPKitErrorCode)code userInfo:(NSDictionary*)userInfo;
+ (FTPKitError*)errorWithTitle:(NSString*)title message:(NSString*)message kitError:(FTPKitErrorCode)code node:(PCNode*)node;

//+ (FTPKitError*)ftp_errorWithTitle:(NSString *)title message:(NSString *)message kitError:(FTPKitErrorCode)code previousErrors:(NSArray*)errors;

+ (FTPKitError*)errorWithTitle:(NSString*)title message:(NSString*)message domain:(NSString*)domain code:(NSInteger)code userInfo:(NSDictionary*)userInfo;

+ (FTPKitError*)errorWithTitle:(NSString *)title message:(NSString*)message code:(NSInteger)code;
+ (FTPKitError*)errorWithTitle:(NSString *)title message:(NSString*)message code:(NSInteger)code userInfo:(NSDictionary*)userInfo;

// connections
+ (FTPKitError*)errorWithCode:(FTPKitErrorCode)code userInfo:(NSDictionary*)userInfo;

// operations
+ (FTPKitError*)cancelledError;

// NSError to FTPKitError conversion
+ (FTPKitError*)ftpKitErrorWithError:(NSError*)error;

@end
