/*
 Note: supporting weird text encodings in Cocoa is a pain, mostly because
 [NSString cString] and [NSString stringWithCString] use the default system text
 encoding, which is different for each language setting.  We've replaced those with
 stringWithRomanString and romanString, which forces NSMacOSRomanEncoding.  We use
 these to preserve the server's name for a file (in item's TRItemKeyRemotePath
 property), and use the displayString method (which calls stringWithUnknownEncoding)
 to decode the name into printable characters.  The encodedString method tries to
 find the best encoding for local filenames on upload.
*/
// XXX - comment out of date - Dave

@interface NSString (PCUnknownEncoding)

+ (NSString*)pc_stringWithBytes:(const char*)str unknownEncoding:(NSStringEncoding*)outEncoding;
+ (NSString*)pc_stringWithUnknownEncoding:(const char*)str;

+ (NSString*)pc_stringWithBytes:(const char*)str encoding:(NSStringEncoding)encoding;

@end
