#import <Cocoa/Cocoa.h>
#import "FTPKitConstants.h"

@class FilePermissions;
@class PCRemoteFileNode;

@interface PCCredentials : NSObject <NSCopying, NSCoding>
{
	NSString* iAddress;
	NSString* iPassword;
	NSData* iIdentity;
	BOOL iIdentityInKeychain;
	int iPort;
	NSString* iUsername;
	FTPKitProtocol iProtocol;
	NSString* key;
	BOOL keyIsDirty;
	NSString* iInitialPath;
	NSStringEncoding iEncoding;
	BOOL iUsePassiveMode;
		
	// connection options
	NSUInteger iMaximumConnections;
	NSArray* asciiFiles;
	FTPUNIXParserNameDateSpacing iNameDateSpacing;
	NSString* iProxyAddress;
	NSString* iProxyPassword;
	int iProxyPort;
	NSString* iProxyUsername;
	int iProxyType;
	int iRedialDelay;
	int iMaxDials;
	FTPKitServerType iServerType;
	int iTimeout;
	BOOL iUseFEAT;
	BOOL iUseMLST;
	BOOL iUseCCC;
	BOOL iUsePRET;
	BOOL iUseVerboseLogging;
	BOOL iKeepConnectionsAlive;
	double iKeepConnectionsAliveDelay;
	BOOL iKeepTransfersAlive;
	double iKeepTransfersAliveDelay;
	BOOL iTransferDSStore;
	NSDictionary* iCustomUploadPermissions;
	NSArray* iCustomS3UploadHeaders;
	BOOL iPreserveModificationDates;
	
	BOOL iNeedsToExpire; // set when settings change that require a reconnect but the connection is active so the connection cannot be terminated right away
}

@property(nonatomic, copy) NSString* address;
@property(nonatomic, copy) NSString* password;
@property(copy) NSData* identity;
@property(getter=isIdentityInKeychain) BOOL identityInKeychain;
@property(nonatomic) int port;
@property(nonatomic, copy) NSString* username;
@property FTPKitProtocol protocol;
@property(copy) NSString* initialPath; // unicode string, not remotely enocoded because of dynamic encoding changes at login
@property NSStringEncoding encoding; // setter calls through to encodingUsingConnectionDefault: using YES for useConnectionEncoding
@property BOOL usePassiveMode;
@property FTPUNIXParserNameDateSpacing nameDateSpacing;
@property(copy) NSString* proxyAddress;
@property(copy) NSString* proxyPassword;
@property int proxyPort;
@property(copy) NSString* proxyUsername;
@property int proxyType;
@property int redialDelay;
@property int maxDials;
@property FTPKitServerType serverType;
@property int timeout;
@property BOOL useFEAT;
@property BOOL useMLST;
@property BOOL useCCC;
@property BOOL usePRET;
@property BOOL useVerboseLogging;
@property BOOL shouldTransferDSStore;
@property BOOL shouldKeepConnectionsAlive;
@property double keepConnectionsAliveDelay;
@property BOOL shouldKeepTransfersAlive;
@property double keepTransfersAliveDelay;
@property(copy) NSDictionary* customUploadPermissions;
@property(copy) NSArray* customS3UploadHeaders;
@property BOOL needsToExpire;
@property NSUInteger maximumConnections;
@property BOOL preserveModificationDates;

- (id)initWithURL:(NSURL*)aURL;

// setters

- (void)setAsciiFiles:(NSArray*)anAsciiFiles;
- (void)setPassword:(NSString*)aPassword saveInKeychain:(BOOL)flag;
- (void)setIdentity:(NSData*)data saveInKeychain:(BOOL)saveInKeychain;

// accessors

- (NSArray*)asciiFiles;
- (FilePermissions*)customPermissionsForNode:(PCRemoteFileNode*)node;
- (NSStringEncoding)encodingUsingConnectionDefault:(BOOL)useConnectionEncoding; // kFTPKitEncodingAutomatic if connection should use its default encoding determined by the connection type
- (int)portUsingDefaultPort;

// private 

- (NSString*)key;

@end
