#import "PCNode.h"
#import "FTPKitConstants.h"

#define countof(x) (sizeof(x) / sizeof(0[x]))

@class PCFolderNode;

#define kPCFileNodeCatalogInfoMask \
	(kFSCatInfoNodeFlags | kFSCatInfoDataSizes | kFSCatInfoFinderInfo | kFSCatInfoPermissions | kFSCatInfoCreateDate | kFSCatInfoContentMod)

@interface PCFileNode : PCNode <NSCoding>
{
	FSRef iFSRef;
	
@private
	NSUInteger iLabel; // index + 1 of color in array or 0 if no label
	BOOL iApplication;
}

@property NSUInteger label;
@property (getter=isApplication) BOOL application;

// This method will check file type via an FSRef and return either a PCAliasNode,
// PCFileNode, or a PCSmartFolder node.

// NOTICE - DO NOT USE: you should use the file manager to create new nodes unless you know what you're doing
+ (id)nodeWithPath:(NSString*)inPath; 
+ (id)nodeWithFSRef:(const FSRef *)fsRef;
+ (id)nodeWithFSRef:(const FSRef*)fsRef catalogInfo:(const FSCatalogInfo*)catalogInfo;
// END NOTICE

- (id)initWithPath:(NSString*)path;
- (id)initWithFSRef:(const FSRef*)fsRef;
- (id)initWithFSRef:(const FSRef*)fsRef catalogInfo:(const FSCatalogInfo*)catalogInfo; // designated initializer

- (BOOL)validateFSRefRecreate:(BOOL)flag;
- (const FSRef*)fsRef;
- (void)setFSRef:(const FSRef*)aRef;

@end


@interface PCFileNode (Private)

- (void)loadFileAttributes:(const FSCatalogInfo*)catalogInfo;
- (void)loadFileAttributes:(const FSCatalogInfo*)catInfo fsRef:(FSRef)fsRef;

@end
