#import "PCVirtualFileManager.h"

@class PCFolderNode;
@class PCLocalArchiveOperation;
@class PCLocalChangeAttributesOperation;
@class PCLocalCopyOperation;
@class PCLocalListDirectoryOperation;
@class PCLocalNewFileOperation;
@class PCLocalNewFolderOperation;
@class PCLocalRenameOperation;
@class PCLocalSumSizeOperation;
@class PCLocalTrashOperation;

@interface PCLocalFileManager : PCVirtualFileManager
{
}

+ (PCLocalFileManager*)defaultManager;

- (PCLocalArchiveOperation*)archiveNodes:(NSArray*)nodes toFolder:(PCFolderNode*)folderNode delegate:(id)delegate;
- (PCLocalSumSizeOperation*)calculateSumSizeOfNodes:(NSArray*)nodes delegate:(id)delegate;
- (PCLocalChangeAttributesOperation*)changeAttributes:(NSDictionary*)attributes recursively:(BOOL)recursively forNodes:(NSArray*)nodes delegate:(id)delegate;
- (PCLocalListDirectoryOperation*)contentsOfNode:(PCFolderNode*)node delegate:(id)delegate;
- (PCLocalCopyOperation*)copyNodes:(NSArray*)nodes toPath:(NSString*)folderPath conflictMode:(FTPKitConflictMode)conflictMode delegate:(id)delegate;
- (PCLocalNewFileOperation*)createFileInFolder:(PCFolderNode*)node withName:(NSString*)name delegate:(id)delegate;
- (PCLocalNewFolderOperation*)createFolderInFolder:(PCFolderNode*)node withName:(NSString*)name delegate:(id)delegate;
- (PCLocalTrashOperation*)deleteNodes:(NSArray*)nodes delegate:(id)delegate;
- (PCLocalCopyOperation*)duplicateNodes:(NSArray*)nodes delegate:(id)delegate;
- (PCLocalRenameOperation*)renameNode:(PCNode*)node to:(NSString*)newName delegate:(id)delegate;
- (PCLocalTrashOperation*)trashNodes:(NSArray*)nodes delegate:(id)delegate;

- (PCFileNode*)nodeForPath:(NSString*)path create:(BOOL)createFlag;
- (PCFileNode*)nodeForUnicodePath:(NSString*)path create:(BOOL)createFlag;
- (PCFileNode*)fileNodeForPath:(NSString*)path create:(BOOL)create;
- (PCFolderNode*)folderNodeForPath:(NSString*)path create:(BOOL)create;
- (PCFileNode*)fileNodeForUnicodePath:(NSString*)path create:(BOOL)create;
- (PCFolderNode*)folderNodeForUnicodePath:(NSString*)path create:(BOOL)create;

- (NSArray*)createNodesForPaths:(NSArray*)paths;

@end
