#import "FTPKitConstants.h"
#import <libkern/OSAtomic.h>

@class FilePermissions;
@class PCUUID;
@protocol PCFolderNode;

@interface PCNode : NSObject <NSCopying>
{
@private
	PCUUID*				iUUID;
	NSString*			iPath;				// Full absolute path to file, including name
	NSString*			iDisplayName;		// Localized name, used for display in interface
	NSDate*				iCreationDate;		// When item was created, usually not applicable for remote items
	NSDate*				iModificationDate;	// Date of last modification
	id					iOwner;				// Owner this item belongs to or NSNull if not applicable
	id					iGroup;				// Group the item belongs to or NSNull if not applicable
	NSNumber*			iOwnerAccountID;
	NSNumber*			iGroupAccountID;
	NSString*			iKind;				// Document type
	FilePermissions*	iPermissions;		// Permissions
	NSNumber*			iSize;				// Logical size of file or nil for folders
	NSNumber*			iPhysicalSize;		// Physical size of file or logical size if not applicable
	BOOL				iVisible;
	
	NSImage*			iIconImage;
	IconRef				iIconRef;
	
	OSSpinLock			iPathLock;
	
	// cached as needed

	NSMutableDictionary* iUserProperties;
	
	__weak PCNode* iParent; // gcc 4.2 segfaults on "__weak PCNode<PCFolderNode>*", but that's what this really is
}

@property(nonatomic, readonly, retain) PCUUID* uuid;
@property(copy) NSString* path;
@property(copy) NSString* displayName;
@property(retain) NSDate* creationDate;
@property(retain) NSDate* modificationDate;
@property(copy) id owner;
@property(copy) id group;
@property(retain) NSNumber* groupAccountID;
@property(retain) NSNumber* ownerAccountID;
@property(copy) NSString* kind;
@property(copy) FilePermissions* permissions;
@property(retain) NSNumber* size;
@property(retain) NSNumber* physicalSize;
@property(getter=isVisible) BOOL visible;
@property FTPKitConflictMode conflictMode;
@property(readonly, copy) NSString* filename;
@property(nonatomic, assign) __weak PCNode* parent;
@property(retain) NSImage* iconImage;
@property(readonly) NSDictionary* attributes;

// transformer conveniences
@property(readonly) NSString* prettySize; // "1,234,567" or "--" for folders
@property(readonly) NSString* prettyPhysicalSize;
@property(readonly) NSString* prettyOwner;
@property(readonly) NSString* prettyGroup;

- (id)initWithPath:(NSString*)path;

- (IconRef)iconRef;
- (void)setIconRef:(IconRef)iconRef;

- (id)userPropertyForKey:(NSString*)key;
- (void)setUserProperty:(id)value forKey:(NSString*)key;

+ (NSArray*)sortDescriptorsForSortType:(FTPSortType)sortType ascending:(BOOL)ascending;

// accessors

- (NSString*)uuidString;
- (NSImage*)iconWithSize:(PCFileSystemIconSize)iconSize;
- (BOOL)isRemote;
- (NSColor*)labelColor;
- (NSString*)displayPath;
- (PCFileSystemType)type;
- (BOOL)isDescendantOf:(PCNode*)aNode;

- (NSString*)unicodeFilename;
- (NSString*)unicodePath;

// for subclasses

- (void)determineVisibility;
- (BOOL)isExpiredAndReloadAttributes:(BOOL)loadDataFlag;
- (void)loadIconRef;


// sudo-private
- (void)setKind__:(NSString*)kind;

@end

extern NSSize ImageSizeForIconSize(PCFileSystemIconSize iconSize);


@interface PCNode (AppleScript)

- (NSScriptObjectSpecifier*)objectSpecifier;
- (NSString*)uniqueID;

@end

@interface PCNode (PublicIn106)

- (id)forwardingTargetForSelector:(SEL)selector;

@end


@interface PCNodePrettySizeTransformer : NSValueTransformer
{}

@end

@interface PCNodePrettyPhysicalSizeTransformer : NSValueTransformer
{}

@end

@interface PCNodePrettyOwnerTransformer : NSValueTransformer
{}

@end

@interface PCNodePrettyGroupTransformer : NSValueTransformer
{}

@end
