#import <Cocoa/Cocoa.h>
#import "FTPKitConstants.h"

@class PCNode;
@class FTPKitError;

@interface PCNodeStatus : NSObject 
{
	PCNode 		*iNode;
	PCOperationState iState;
	double		iBytesTransferred;
	double		iTotalBytes;
	double		iKBytesPerSecond;
	BOOL		iStalled;
	FTPKitError	*iError;
	NSString	*iDetailedCaption; // if set, uses this caption, otherwise generates caption based on state
}

- (id)initWithNode:(PCNode*)aNode;

@property double bytesTransferred;
@property double totalBytes;
@property double kBytesPerSecond;
@property PCOperationState state;
@property (getter=isStalled) BOOL stalled;
@property (copy) FTPKitError* error;
@property (readonly) PCNode* node;

// status string EG: "(stalled) 1MB of 5 MB, 5 minutes remaining, 54 kb/s"
@property (copy) NSString* detailedCaption;

// fraction of 1.0
- (double)progress;

- (NSString*)detailedCaption;

// size status string EG: "1MB of 5 MB"
- (NSString*)sizeCaption;

- (long long)secondsRemaining;

// convenience methods for determining state

- (BOOL)isReady;
- (BOOL)isIndeterminate;
- (BOOL)isExecuting;
- (BOOL)isFinished;

@end