//
//  PCOperationResult.h
//  FTPKit
//
//  Created by Wade Cosgrove on 11/12/09.
//  Copyright 2009 Panic, Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class PCFSOperation;
@class PCNode;
@class FTPKitError;

@interface PCOperationResult : NSObject
{
	__weak PCFSOperation *iOperation;
	NSMapTable *iCreatedToExistingNodeMap; 	// object is newly created node, key is the source node
	NSMutableSet *iModifiedNodes;			// source nodes that were modified by the operation
	NSMutableSet *iDeletedNodes;
	NSMutableSet *iCreatedNodes;
	NSObject *iResultObject;				// an object that represents the operation result, if applicable
	NSMutableArray *iErrors;
}

- (id)initWithOperation:(PCFSOperation*)operation;

@property (retain) NSObject *resultObject;
@property (readonly) NSMutableSet *modifiedNodes;
@property (readonly) NSMutableSet *deletedNodes;
@property (readonly) NSMutableSet *createdNodes;
@property (readonly) NSArray *errors;

- (PCNode*)createdNodeForSource:(PCNode*)sourceNode;
- (void)removeCreatedNodeForSource:(PCNode*)sourceNode;
- (void)setCreatedNode:(PCNode*)newNode forSource:(PCNode*)sourceNode;
- (void)addCreatedNode:(PCNode*)createdNode;
- (BOOL)containsCreatedNode:(PCNode*)createdNode;

- (void)addModifiedNode:(PCNode*)modifiedNode;
- (BOOL)containsModifiedNode:(PCNode*)modifiedNode;

- (void)addDeletedNode:(PCNode*)deletedNode;
- (BOOL)containsDeletedNode:(PCNode*)deletedNode;

- (void)addObjectsFromResult:(PCOperationResult*)result;
- (void)clearResult;

- (void)addError:(FTPKitError*)error;
- (void)setError:(FTPKitError*)error; // only use if the operation is going to report a single error

@end
