#import <Cocoa/Cocoa.h>
#import "FTPKitConstants.h"

@class PCNode;
@class PCNodeStatus;

@interface PCOperationStatus : NSObject <NSCopying>
{
	PCOperationState	iState;
	NSUInteger			iIndex;				// current 0-based index of count
	NSUInteger			iCount;				// total items of the operation
	NSString			*iCaption;
	PCNodeStatus		*iNodeStatus;
	PCNode				*iDestinationNode;
	
	long long			iTotalProgressBytes;	// total bytes of the complete operation
	unsigned long long	iProgressBytes;			// the current amount of bytes completed out of total progress bytes
	double				iKBytesPerSecond;
	BOOL				iStalled;
}

@property NSUInteger index;
@property NSUInteger count;
@property double kBytesPerSecond;
@property(getter=isStalled) BOOL stalled;
@property unsigned long long progressBytes;
@property long long totalProgressBytes;
@property(retain) PCNode *destinationNode;
@property(retain) NSString *caption;
@property(retain) PCNodeStatus *nodeStatus;
@property PCOperationState state;

+ (PCOperationStatus*)operationStatus;

- (double)progress;

// status string EG: "1 of 2: (stalled) 1MB of 5 MB, 5 minutes remaining, 54 kb/s"
- (NSString*)detailedCaption;
// same as above, but shows the file size of the current file instead of the operation
- (NSString*)detailedNodeCaption;

- (long long)secondsRemaining;

- (PCNodeStatus*)nodeStatus;

- (BOOL)isReady;
- (BOOL)isExecuting;
- (BOOL)isCancelled;
- (BOOL)isFinished;

- (void)clearStatus;

@end
