#import "FTPKitConstants.h"
#import "PCRemoteTransferOperation.h"

@class PCFolderNode;
@class PCRemoteFileNode;

@interface PCRemoteDownloadOperation : PCRemoteTransferOperation 
{
@private
	NSArray*			iSourcePaths;
	PCFolderNode*		iDestinationNode;
	BOOL				iQuarantineFiles;
	NSDate*				iLastUIUpdate;
	BOOL				iDelegateSupportsDidDownloadCallback;
}

@property BOOL quarantineFiles;

- (id)initWithNodes:(NSArray*)someNodes localFolder:(PCFolderNode*)destination conflictMode:(FTPKitConflictMode)conflictMode;
- (id)initWithPaths:(NSArray*)somePaths localFolder:(PCFolderNode*)destination conflictMode:(FTPKitConflictMode)conflictMode;

@end


// interface delegate addition

@interface NSObject (PCFSRemoteDownloadOperationDelegate)

- (void)operation:(PCRemoteDownloadOperation*)operation didDownloadNode:(PCRemoteFileNode*)remoteNode to:(PCFileNode*)localNode;

@end
