#import "PCRemoteTransferOperation.h"
#import <Cocoa/Cocoa.h>

@class FTPConnection;
@class PCCredentials;
@class PCRemoteFileManager;
@class PCRemoteFolderNode;


@interface PCRemoteFXPOperation : PCRemoteTransferOperation
{
	NSString*		iDestinationPath;
	PCCredentials*	iDestinationCredentials;
	FTPConnection*	iDestinationConnection;
	PCRemoteFileManager* iDestinationFileManager;
	NSDate*			iLastUIUpdate; // may be able to remove?

	BOOL			iUseFallbackUploadMethod;
	int				iOriginalSourceTimeout;
	int 			iOriginalDestinationTimeout;
}

- (id)initWithNodes:(NSArray*)someNodes remotePath:(NSString*)aDestinationPath destinationServerCredentials:(PCCredentials*)destCredentials conflictMode:(FTPKitConflictMode)aConflictMode;

@end
