#import "PCVirtualFileManager.h"

@class AbstractConnection;
@class PCConnectionPool;
@class PCCredentials;
@class PCRemoteAliasNode;
@class PCRemoteCacheNodesOperation;
@class PCRemoteChangeAttributesOperation;
@class PCRemoteChangeDirectoryOperation;
@class PCRemoteConnectOperation;
@class PCRemoteCopyOperation;
@class PCRemoteDeleteOperation;
@class PCRemoteDownloadOperation;
@class PCRemoteFileNode;
@class PCRemoteFolderNode;
@class PCRemoteFXPOperation;
@class PCRemoteGetAttributesOperation;
@class PCRemoteListDirectoryOperation;
@class PCRemoteMoveOperation;
@class PCRemoteNewFileOperation;
@class PCRemoteNewFolderOperation;
@class PCRemoteOperation;
@class PCRemotePublishOperation;
@class PCRemoteRawCommandOperation;
@class PCRemoteRenameOperation;
@class PCRemoteResolveSymlinkOperation;
@class PCRemoteReversePublishOperation;
@class PCRemoteSumSizeOperation;
@class PCRemoteSynchronizeOperation;
@class PCRemoteUploadOperation;

@interface PCRemoteFileManager : PCVirtualFileManager
{
@private
	PCConnectionPool* iConnectionPool;
	PCRemoteFolderNode* iLoginNode;
	BOOL iSupportsAtomicUploads;
}

@property(readonly, retain) PCConnectionPool* connectionPool;
@property(retain) PCRemoteFolderNode* loginNode; // This is the node that the server logged the user into by default for the credentials given
@property(assign) BOOL supportsAtomicUploads;

// To obtain access to a file manager use remoteManagerForCredentials… this will return an autoreleased manager

+ (PCRemoteFileManager*)remoteManagerForCredentials:(PCCredentials*)credentials;
+ (PCRemoteFileManager*)remoteManagerForCredentials:(PCCredentials*)credentials create:(BOOL)createIfNeeded;
+ (NSArray*)remoteManagers;

- (PCRemoteCacheNodesOperation*)cacheNodes:(NSArray*)nodes replaceExistingFiles:(BOOL)replace delegate:(id)delegate;
- (PCRemoteSumSizeOperation*)calculateSumSizeOfNodes:(NSArray*)nodes delegate:(id)delegate;
- (PCRemoteChangeDirectoryOperation*)changeDirectoryAndCreateNode:(NSString*)path delegate:(id)delegate;
- (PCRemoteChangeAttributesOperation*)changeAttributes:(NSDictionary*)dictionary recursively:(BOOL)recursively forNodes:(NSArray*)nodes delegate:(id)delegate;
- (PCRemoteConnectOperation*)connectWithInitialPath:(NSString*)initialPath /* initial path may be nil */ delegate:(id)delegate;
- (PCRemoteListDirectoryOperation*)contentsOfNode:(PCRemoteFolderNode*)node delegate:(id)delegate;
- (PCRemoteCopyOperation*)copyNodes:(NSArray*)nodes toPath:(NSString*)toPath conflictMode:(FTPKitConflictMode)conflictMode delegate:(id)delegate;
- (PCRemoteNewFileOperation*)createFileInFolder:(PCRemoteFolderNode*)node withName:(NSString*)name delegate:(id)delegate;
- (PCRemoteNewFolderOperation*)createFolderInFolder:(PCRemoteFolderNode*)node withName:(NSString*)name delegate:(id)delegate;
- (PCRemoteDeleteOperation*)deleteNodes:(NSArray*)nodes delegate:(id)delegate;
- (PCRemoteDeleteOperation*)deletePaths:(NSArray*)paths delegate:(id)delegate;
- (PCRemoteDownloadOperation*)downloadNodes:(NSArray*)sourceNodes toFolder:(PCFolderNode*)destinationNode conflictMode:(FTPKitConflictMode)conflictMode delegate:(id)delegate;
- (PCRemoteDownloadOperation*)downloadPaths:(NSArray*)sourcePaths toFolder:(PCFolderNode*)destinationNode conflictMode:(FTPKitConflictMode)conflictMode delegate:(id)delegate;
- (PCRemoteCopyOperation*)duplicateNodes:(NSArray*)nodes delegate:(id)delegate;
- (PCRemoteSynchronizeOperation*)synchronizeWithRemotePath:(NSString*)remotePath localPath:(NSString*)localPath options:(NSDictionary*)someOptions delegate:(id)delegate;
- (PCRemoteGetAttributesOperation*)getAttributesForNodes:(NSArray*)sourceNodes delegate:(id)delegate;
- (PCRemoteMoveOperation*)moveNodes:(NSArray*)nodes toPath:(NSString*)folderPath conflictMode:(FTPKitConflictMode)conflictMode delegate:(id)delegate;
- (PCRemotePublishOperation*)publishNodes:(NSArray*)sourceNodes localRootPath:(NSString*)localPath remoteRootPath:(NSString*)remotePath conflictMode:(FTPKitConflictMode)conflictMode delegate:(id)delegate;
- (PCRemoteRenameOperation*)renameFileAtPath:(NSString*)sourcePath to:(NSString*)newName delegate:(id)delegate;
- (PCRemoteRenameOperation*)renameNode:(PCRemoteFileNode*)node to:(NSString*)newName delegate:(id)delegate;
- (PCRemoteResolveSymlinkOperation*)resolveSymlink:(PCRemoteAliasNode*)node delegate:(id)delegate;
- (PCRemoteReversePublishOperation*)reversePublishNodes:(NSArray*)sourceNodes remoteRootPath:(NSString*)remotePath localRootPath:(NSString*)localPath conflictMode:(FTPKitConflictMode)conflictMode delegate:(id)delegate;
- (PCRemoteRawCommandOperation*)sendRawCommand:(NSString*)command delegate:(id)delegate;
- (PCRemoteUploadOperation*)uploadNodes:(NSArray*)sourceNodes toFolder:(NSString*)destinationPath conflictMode:(FTPKitConflictMode)conflictMode delegate:(id)delegate;
- (PCRemoteFXPOperation*)transferNodes:(NSArray*)someNodes toFolder:(NSString*)destinationPath onServerWithCredentials:(PCCredentials*)destinationCredentials conflictMode:(FTPKitConflictMode)conflictMode delegate:(id)delegate;

- (PCRemoteFileNode*)fileNodeForPath:(NSString*)path create:(BOOL)create;
- (PCRemoteFolderNode*)folderNodeForPath:(NSString*)inPath create:(BOOL)create;
- (PCRemoteFileNode*)fileNodeForUnicodePath:(NSString*)path create:(BOOL)create;
- (PCRemoteFolderNode*)folderNodeForUnicodePath:(NSString*)inPath create:(BOOL)create;

- (NSString*)pathRelativeToLoginPath:(NSString*)relativePath;

// accessors
- (BOOL)hasConnected;
+ (NSSet*)activeConnections;

- (void)setTranscriptDelegate:(id)aDelegate;
- (id)transcriptDelegate;

- (PCCredentials*)credentials;

- (NSString*)address;
- (void)disconnectIdleConnections;
- (NSString*)password;
- (int)port;
- (FTPKitProtocol)protocol;
- (NSString*)username;

@end
