#import "PCFileNode.h"

@class BucketLoggingStatus;
@class PCCredentials;
@class PCFileNode;

@interface PCRemoteFileNode : PCNode 
{
	PCCredentials* iCredentials;
}

@property(retain) PCCredentials* credentials;

+ (NSImage*)iconWithExtension:(NSString*)inExtension withSize:(PCFileSystemIconSize)iconSize;
+ (id)fileNodeWithPath:(NSString*)inPath credentials:(PCCredentials*)inCredentials;


- (id)initWithPath:(NSString*)inPath credentials:(PCCredentials*)inCredentials;

- (NSString*)urlStringWithPassword:(BOOL)flag;

@end

@interface PCRemoteFileNode (S3)

// user properties with dedicated accessors for convenience
@property(retain, nonatomic) PCFileNode* cachedNode;
@property(copy) NSString* S3CanonicalOwner;
@property(retain) NSNumber* bucketRegionIndex;
@property(copy) NSString* bucketLocationConstraint;
@property(retain) BucketLoggingStatus* BucketLoggingStatus;
@property(copy) NSArray* CloudFrontDistributions;

@end

@interface PCRemoteFileNode (CloudFiles)

@property(retain) NSNumber* logRetentionEnabled;
@property(retain) NSNumber* CDNEnabled;
@property(retain) NSString* CDNURI;

@end