#import "PCRemoteOperation.h"

@class AbstractConnection;
@class PCRemoteFolderNode;

@interface PCRemoteNewFileOperation : PCRemoteOperation
{
	PCRemoteFolderNode	*iDestinationNode;
	NSString			*iNewFilename;
	NSDate				*iCustomModificationDate;
}

@property (nonatomic, copy) NSString *newFilename;

// pass in nil to get default unique name
- (id)initWithDestination:(PCRemoteFolderNode*)inDestination name:(NSString*)inName;
- (id)initWithDestination:(PCRemoteFolderNode*)inDestination name:(NSString*)inName modificationDate:(NSDate*)aCustomModificationDate;

@end

@interface PCRemoteNewFileOperation (PreventUnnecessaryCasting)

+ (PCRemoteNewFileOperation*)alloc;

@end
