#import "PCFSOperation.h"
#import "AbstractConnection.h"

@class PCRemoteFileNode;
@class PCUUID;

@interface PCRemoteOperation : PCFSOperation <AbstractConnectionProgressMonitoring>
{
@private
	AbstractConnection* iConnection;
	BOOL iOwnsConnection;
	BOOL iSecure;
	PCTrust* iTrust;
	NSInvocation* iCancelAcquireConnection;
}

@property(nonatomic, readonly, retain) AbstractConnection* connection;
@property(nonatomic, readonly) BOOL ownsConnection; // If YES (the default value), this operation will act as delegate for the connection and release it back to the connection pool on operationDidEnd.
@property(readonly) BOOL isSecure;
@property(readonly, retain) PCTrust* trust;

- (PCNode*)currentDestinationNode;

- (void)setConnection:(AbstractConnection*)connection isOwner:(BOOL)isOwner;
- (void)setCurrentDestinationNode:(PCNode*)inNode;

// operation helpers

- (NSString*)remoteStringForDisplayString:(NSString*)string;
- (NSString*)displayStringForRemoteString:(NSString*)string;

- (BOOL)nodesFromPaths:(NSArray*)inPath nodes:(NSArray**)outNodes withError:(FTPKitError**)error;

@end

@interface PCRemoteOperation (Private)

- (AbstractConnection*)acquireConnection;

@end
