#import "PCRemoteTransferOperation.h"

// option dictionary keys

#define SyncOptionMethod									@"SyncOptionMethod"								/* SyncMethod define */
#define SyncOptionFollowSymbolicLinks						@"SyncOptionFollowSymbolicLinks"				/* NSNumber (bool) */
#define SyncOptionServerTimeOffset							@"SyncOptionServerTimeOffset"					/* NSNumber (NSTimeInterval) */
#define SyncOptionDetermineServerTimeAutomatically			@"SyncOptionDetermineServerTimeAutomatically"	/* NSNumber (bool) */
#define SyncOptionSkipFilesOlderThan						@"SyncOptionSkipFilesOlderThan"					/* NSDate */
#define SyncOptionSimulation								@"SyncOptionSimulation"							/* NSNumber (bool) */
#define SyncOptionUploadSync								@"SyncOptionUploadSync"							/* NSNumber (bool) */
#define SyncOptionCompareSize								@"SyncOptionCompareSize"						/* NSNumber (bool) */

// sync method types

#define SyncMethodMirror					@"SyncMethodMirror"
#define SyncMethodUpdate					@"SyncMethodUpdate"

// result data keys

#define SyncActivityAllFiles				@"SyncAllFiles"
#define SyncActivitySkippedFiles			@"SyncSkippedFiles"
#define SyncActivityTransferredFiles		@"SyncTransferredFiles"
#define SyncActivityDeletedFiles			@"SyncDeletedFiles"
#define SyncActivityOptions					@"SyncOptions"							/* NSDictionary - the operation options dictionary */

// sync activity actions

typedef enum
{
	SyncActionTransfer = 0,
	SyncActionDelete,
	SyncActionSkip
}
PCSyncAction;

@interface PCRemoteSynchronizeOperation : PCRemoteTransferOperation
{
@private
	NSString* iLocalPath;
	NSString* iRemotePath;
	NSMutableDictionary* iOptions;

	NSMutableArray* iTransferredItems;
	NSMutableArray* iSkippedItems;
	NSMutableArray* iDeletedItems;

	// options

	BOOL				isMirrorSync;
	NSTimeInterval		serverTimeOffset;
	BOOL				compareUsingSize;
	NSDate*				iModificationCutOffDate;
	BOOL				simulationMode;
	
	// strings
	NSString*			iFileModDatesAreEqual;
	NSString*			iRemoteFileNewer;
	NSString*			iFileSizeEqual;
	NSString*			iRemoteFileLarger;
	NSString*			iLocalFileLarger;
	NSString*			iRemoteFolderDidNotExist;
	NSString*			iRemoteFileDidNotExist;
	NSString*			iComparingFiles;
	NSString*			iSyncHiddenFile;
	NSString*			iHiddenFile;
	NSString*			iFileMatchedSkipRule;
	NSString*			iLocalSizeDiff;
	NSString*			iRemoteSizeDiff;
	NSString*			iLocalFolderDidNotExist;
	NSString*			iLocalFileDidNotExist;
	NSString*			iEvaluatingRemoteItem;
	NSString*			iEvaluatingLocalItem;
	NSString*			iLocalFileNewer;
	NSString*			iDeleteLocalOrphanedFile;
	NSString*			iDeleteRemoteOrphanedFile;
}

@property(readonly, copy) NSString* localPath;
@property(readonly, copy) NSString* remotePath;

- (id)initWithRemotePath:(NSString*)aRemotePath localPath:(NSString*)aLocalPath options:(NSDictionary*)someOptions;

- (BOOL)downloadSyncWithRemotePath:(NSString*)inRemotePath localPath:(NSString*)inLocalPath;
- (BOOL)uploadSyncWithLocalPath:(NSString*)inLocalPath remotePath:(NSString*)inRemotePath remoteRootPathExists:(BOOL)remoteRootPathExists;

- (NSDictionary*)options;

@end


@interface PCSynchronizeItemReport : NSObject
{
	PCNode			*iNode;
	PCSyncAction	iAction;
	NSString		*iDescription;
}

@property (retain) PCNode* node;
@property PCSyncAction action;
@property (retain) NSString *description;

+ (PCSynchronizeItemReport*)report;

@end