#import "PCRemoteOperation.h"

@protocol PCFolderNode;

@interface PCRemoteTransferOperation : PCRemoteOperation
{
	BOOL iCalculateTotalProgress;
	BOOL iFollowSymlinks;
	FTPKitConflictMode iConflictMode;
	NSMutableDictionary *iConflictModeMapping;
	
@private
	BOOL iTransferHiddenFiles;
	char iTransferMode;
	NSCompoundPredicate* iSkipFilesUserPredicate;
	NSCompoundPredicate* iSkipFilesComputedPredicate;
}

@property BOOL calculateTotalProgress;
@property BOOL followsSymlinks;
@property BOOL shouldTransferHiddenFiles;
@property char transferMode;
@property FTPKitConflictMode conflictMode;

@property(readonly) NSCompoundPredicate* skipFilesPredicate; // generated from the two properties below
@property(readonly) NSCompoundPredicate* skipFilesBasePredicate;
@property(readwrite, retain) NSCompoundPredicate* skipFilesUserPredicate;

// intended for subclasses

- (BOOL)calculateTotalBytesToTransferFromNodes:(NSArray*)nodes;

- (BOOL)shouldTransferNode:(PCNode*)node; // allows the operation/connection to filter files to transfer

// primarily for internal use by subclasses

- (BOOL)preflightNodeConflicts:(NSMutableArray*)nodes newNames:(NSMutableArray*)destinationFileNames forDestination:(PCNode<PCFolderNode>*)destinationFolder;
- (FTPKitConflictMode)resolveConflict:(PCNode*)inSourceNode destination:(PCNode*)inDestinationNode;
- (FTPKitConflictMode)conflictModeForNode:(PCNode*)sourceNode destination:(PCNode*)destinationNode;
- (void)setConflictMode:(FTPKitConflictMode)conflictMode forNode:(PCNode*)node;

@end


@interface PCRemoteTransferOperation (AbstractConnectionProgressDelegate)

- (void)connection:(AbstractConnection*)aConnection incrementTotalProgressBy:(unsigned long long)incrementAmount;

@end
