#import "FTPKitConstants.h"
#import <Cocoa/Cocoa.h>

@interface PCSortController : NSObject 
{
	NSMapTable* iCacheMap;
}

@property(nonatomic, readonly, retain) NSMapTable* cacheMap;

+ (NSArray*)sortedArrayWithNodes:(NSArray*)nodes sortType:(FTPSortType)sortType subSortType:(FTPSortType)subSortType order:(NSComparisonResult)order;
+ (NSArray*)sortedArrayByInsertingNodes:(NSArray*)nodes intoArray:(NSArray*)intoArray sortType:(FTPSortType)sortType subSortType:(FTPSortType)subSortType order:(NSComparisonResult)order;

- (NSArray*)setContentsBySortingNodes:(NSArray*)contents forKey:(id)key sortType:(FTPSortType)sortType subSortType:(FTPSortType)subSortType order:(NSComparisonResult)order;
- (void)setSortedContents:(NSArray*)contents forKey:(id)key sortType:(FTPSortType)sortType subSortType:(FTPSortType)subSortType order:(NSComparisonResult)order;
- (void)updateContentsByInsertingNodes:(NSArray*)inserted forKey:(id)key sortType:(FTPSortType)sortType subSortType:(FTPSortType)subSortType order:(NSComparisonResult)order;
- (void)updateContentsByRemovingNodes:(NSArray*)removed forKey:(id)key sortType:(FTPSortType)sortType subSortType:(FTPSortType)subSortType order:(NSComparisonResult)order;

- (void)sortContentsForKey:(id)key sortType:(FTPSortType)sortType subSortType:(FTPSortType)subSortType order:(NSComparisonResult)order;

- (NSArray*)contentsForKey:(id)key;
- (NSComparisonResult)orderForKey:(id)key;
- (FTPSortType)sortTypeForKey:(id)key;
- (FTPSortType)subSortTypeForKey:(id)key;

- (void)removeAllContents;
- (void)removeContentsForKey:(id)aKey;

@end
