#import "FTPKitConstants.h"
#import "PCFolderNode.h"
#import <Cocoa/Cocoa.h>

@class PCNode;
@class PCNodeStatus;
@class PCFileNode;
@class PCFolderNode;
@class PCFSOperation;
@class PCUUID;
@class PCTimer;

@interface PCVirtualFileManager : NSObject
{
	PCNode* iRootLevelNode;
	NSRecursiveLock* iCacheAccessLock;
	PCTimer* iExpireAllDelayTimer;
	
	NSMutableDictionary* iRunningOperations;
}

+ (NSString*)approximateFileSizeStringForSize:(unsigned long long)aSize;
+ (NSString*)convertSecondsToTime:(long)inSeconds;
+ (NSString*)exactFileSizeStringForSize:(unsigned long long)aSize;

// TODO: these methods should be changed to fileNodeAtPath: & folderNodeAtPath: -wac

- (PCNode*)fileNodeForPath:(NSString*)path create:(BOOL)createFlag;
- (PCNode*)folderNodeForPath:(NSString*)path create:(BOOL)createFlag;
- (PCNode*)fileNodeForUnicodePath:(NSString*)path create:(BOOL)createFlag;
- (PCNode*)folderNodeForUnicodePath:(NSString*)path create:(BOOL)createFlag;

- (PCFSOperation*)calculateSumSizeOfNodes:(NSArray*)nodes delegate:(id)delegate;
- (PCFSOperation*)copyNodes:(NSArray*)nodes toPath:(NSString*)toPath delegate:(id)delegate;
- (PCFSOperation*)copyNodes:(NSArray*)nodes toPath:(NSString*)folderPath conflictMode:(FTPKitConflictMode)conflictMode delegate:(id)delegate;

- (PCFSOperation*)duplicateNodes:(NSArray*)nodes delegate:(id)delegate;
- (PCFSOperation*)deleteNodes:(NSArray*)nodes delegate:(id)delegate;
- (PCFSOperation*)deletePaths:(NSArray*)paths delegate:(id)delegate;
- (PCFSOperation*)moveNodes:(NSArray*)nodes toPath:(NSString*)folderPath delegate:(id)delegate;
- (PCFSOperation*)moveNodes:(NSArray*)nodes toPath:(NSString*)folderPath conflictMode:(FTPKitConflictMode)conflictMode delegate:(id)delegate;
- (PCFSOperation*)renameNode:(PCNode*)node to:(NSString*)newName delegate:(id)delegate;

- (PCFSOperation*)contentsOfNode:(PCNode*)node delegate:(id)delegate;

- (PCFSOperation*)createFileInFolder:(PCNode*)node withName:(NSString*)name delegate:(id)delegate;
- (PCFSOperation*)createFolderInFolder:(PCNode*)node withName:(NSString*)name delegate:(id)delegate;
- (PCFSOperation*)changeAttributes:(NSDictionary*)attributes recursively:(BOOL)recursively forNodes:(NSArray*)nodes delegate:(id)delegate;

- (PCFSOperation*)downloadHTTPURL:(NSURL*)url toFolder:(PCFolderNode*)destinationNode delegate:(id)aDelegate;

- (PCFSOperation*)duplicateOperationMatching:(PCFSOperation*)operation delegate:(id)aDelegate;
- (PCNodeStatus*)firstActiveStatusForNode:(PCNode*)aNode operation:(PCFSOperation**)retOp;
- (PCFSOperation*)operationWithUUID:(PCUUID*)uuid;

- (NSSet*)cancelOperationsWithInterfaceDelegate:(id)inDelegate;
- (PCFSOperation*)firstOperationForInterfaceDelegate:(id)inDelegate;

- (NSString*)pathByResolvingPath:(NSString*)path;
- (NSString*)pathByResolvingPath:(NSString*)path relativeToParent:(NSString*)parentPath;
- (NSArray*)completedPaths:(NSString*)uncompletedPath rootNode:(PCNode*)rootNode withHidden:(BOOL)includeHidden foldersOnly:(BOOL)foldersOnly;

- (PCNode<PCFolderNode>*)rootNode;

- (void)cancelExpireAllFolders;
- (void)expireAllFolders;

// designated start operation method for the file manager, filters duplicate operations

- (PCFSOperation*)startOperation:(PCFSOperation*)operation delegate:(id)delegate;

@end

@interface PCApproximateFileSizeStringTransformer : NSValueTransformer
{}

@end

@interface PCExactFileSizeStringTransformer : NSValueTransformer
{}

@end
