#import "AbstractConnection.h"

#import "ne_basic.h"
#import "ne_locks.h"
#import "ne_session.h"

@class FTPKitHTTPCookieStore;

typedef int UTF8CompositionMapping;
enum
{
	kUTF8CompositionMapUnknown = 0,
	kUTF8CompositionMapPrecomposed,
	kUTF8CompositionMapDecomposed,
};



@interface WebDAVConnection : AbstractConnection
{
@private
	ne_session				*session;
	ne_lock_store			*lock_store;
	unsigned int			capabilities;

	unsigned long long		iStartingOffset;
	unsigned long long		iUploadFileSize;
	
	BOOL					isDotMac; // MobileMe iDisk
	
	int						lastLogFlag;

	ne_session_status		iNotifierStatus;
	
	UTF8CompositionMapping	iUTF8Mapping;
	
	__weak NSFileHandle* iStreamingFileHandle;
	
	NSURL* iCookieURL;
}

@property(readonly) ne_session_status notifierStatus;

@end
