//
//  HDCrashReporter.h
//
//  HDCrashReporter is a framework to send back to the developer the crash reports 
//  and the console log after a crash.
//  Copyright (C) 2006 Humble Daisy
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//  For more information contact: developers@profcast.com
//

#import <Cocoa/Cocoa.h>

#define HDCrashReporterCompanyNameInfoKey		@"HDCrashReporterCompanyName"
#define HDCrashReporterConsoleLogLinesInfoKey	@"HDCrashReporterConsoleLogLines"

typedef enum
{
	ReportCrash = 0,
	ReportException
} ReportType;

@interface HDCrashReporter : NSWindowController
{
	BOOL				iSendConsoleLog;
	BOOL				iShowDetails;
	BOOL				iSending;
	
	IBOutlet NSPanel	*sendingPanel;
	IBOutlet NSSplitView*hiddenView;
	IBOutlet NSButton	*showDetailsButton;
	IBOutlet NSButton	*sendButton;
	IBOutlet NSTextField *emailField;
	IBOutlet NSTextView *reportTextView;
	IBOutlet NSTextView  *consoleTextView;
	IBOutlet NSTextView  *commentsTextView;
	IBOutlet NSTextField *commentsPlaceholderTextField;
	IBOutlet NSTextField *titleField;
	IBOutlet NSTextField *messageField;
	IBOutlet NSProgressIndicator *loadingSpinner;
	IBOutlet NSImageView *errorImageView;
	
	NSURLResponse		*iResponse;

	NSURL				*iReportURL;
	ReportType			iReportType;
}

@property (retain) NSURL *reportURL;
@property BOOL sendConsoleLog;
@property BOOL showDetails;
@property (getter=isSending, setter=setIsSending:) BOOL sending;

+ (HDCrashReporter*)defaultExceptionReporter;
+ (HDCrashReporter*)defaultCrashReporter;

+ (BOOL)newCrashLogExists;
+ (void)doCrashReporting:(NSURL*)aReportURL;
+ (void)doExceptionReporting:(NSURL*)aReportURL exception:(NSException*)exception;
+ (NSString*)symbolizeException:(NSException*)exception;

- (IBAction)sendReport:(id)sender;
- (IBAction)showDetails:(id)sender;
- (IBAction)cancel:(id)sender;
@end


@interface HDPlaceholderTextView : NSTextView
{
	NSAttributedString *iPlaceholderString;
}

@property (nonatomic, copy) NSAttributedString *attributedPlaceholderString;

@end