#import <Cocoa/Cocoa.h>

@class DragImageView;

@interface DragImageAnimator : NSObject
{	
	NSView			*sourceView;
	NSWindow		*dragImageWindow;
	__weak DragImageView *dragImageView;
	
	NSPoint			dragStartWindowOrigin;
	BOOL			dragInsideDestinationView;
	
	BOOL			iAskSourceForWindow;
	NSWindow		*iMorphingWindow;
}

@property (nonatomic, readonly) NSWindow* morphingWindow;

- (id)initWithImage:(NSImage*)anImage alternateImage:(NSImage*)anotherImage sourceView:(NSView*)aView;
- (id)initWithImage:(NSImage*)anImage morphingWindow:(NSWindow*)aWindow sourceView:(NSView*)aView;
- (id)initWithImage:(NSImage*)anImage morphingIntoProvidedWindowFromSourceView:(NSView*)aView;

- (NSView*)draggingSource;

// source view methods

- (void)beginDragWithEvent:(NSEvent*)dragEvent pasteboard:(NSPasteboard*)pboard;
- (BOOL)draggedImageEndedAt:(NSPoint)aPoint operation:(NSDragOperation)op;
- (void)movedTo:(NSPoint)screenPoint;

- (void)zoomMorphingWindowFromPoint:(NSPoint)point;

// destination view methods

- (void)draggingEntered:(id <NSDraggingInfo>)sender destination:(NSView*)destinationView;
- (void)draggingExited:(id <NSDraggingInfo>)sender;// destination:(NSView*)destinationView;
- (void)draggingUpdated:(id <NSDraggingInfo>)sender destination:(NSView*)destinationView;

// private

- (NSImage*)endImageWithWindow:(NSWindow*)aWindow;
- (BOOL)isPointValidDropTarget:(NSPoint)screenPoint;
- (void)obtainMorphingWindowFromSourceView;

@end


@interface DragImageView : NSView
{
	CGFloat	imageAlpha;
	CGFloat	stepDelta;
	NSTimer *animationTimer;
	
	NSImage *iStartImage;
	NSImage *iEndImage;
	NSRect	iStartImageRect;
	NSRect	iEndImageRect;
}

@property(nonatomic, retain) NSImage* startImage;
@property(nonatomic, retain) NSImage* endImage;

- (CGFloat)imageAlpha;
- (NSImage*)dragImage;

- (void)startAnimationWithStepDelta:(CGFloat)delta;
- (void)stopAnimation;

@end


@interface NSView (DragImageAnimatorWindowProvider)

- (NSWindow*)pc_morphingWindowForDragImageAnimator:(DragImageAnimator*)animator;

// gives the source view (and its delegate) a chance to configure window before opening fully

- (void)pc_dragImageAnimator:(DragImageAnimator*)animator willZoomMorphingWindow:(NSWindow*)window;

@end
