#import <Cocoa/Cocoa.h>

#define kESImageButtonNormal			@"ESImageButtonNormal"
#define kESImageButtonInactiveNormal	@"ESImageButtonInactiveNormal"
#define kESImageButtonDisabled			@"ESImageButtonDisabled"
#define kESImageButtonRollover			@"ESImageButtonRollover"
#define kESImageButtonGraphitePressed	@"ESImageButtonGraphite"
#define kESImageButtonAquaPressed		@"ESImageButtonAqua"

@interface ESImageButtonCell : NSButtonCell
{
@private
	NSImage		*normalImage;
	NSImage		*disabledImage;
	NSImage		*rollOverImage;
	NSImage		*pressedAquaImage;
	NSImage		*pressedGraphiteImage;
	NSImage		*inactiveNormalImage;

	// Current pressed image
	NSImage		*pressedImage;
	
	// Needed to support NSCoding protocol
	NSString	*graphiteImageName;
	NSString	*aquaImageName;
	NSString	*normalImageName;
	NSString	*disabledImageName;
	NSString	*rollOverImageName;
	NSString	*inactiveNormalImageName;
	//
	
	BOOL 		iRolloverHighlighted;
}


- (BOOL)supportsRollover;
- (void)loadPressedImage;

- (void)setRolloverHighlighted:(BOOL)flag;

- (NSImage*)imageForButtonKey:(NSString*)inString;
- (NSString*)imageNameForButtonKey:(NSString*)inString;
- (void)setImage:(NSImage*)inImage forButtonKey:(NSString*)inString;
- (void)setImageNamed:(NSString*)inImageName forButtonKey:(NSString*)inString;

@end


@interface ESImageButton : NSButton
{
	NSTrackingArea *iRolloverArea;
}

- (id)initWithFrame:(NSRect)aFrame imageDictionary:(NSDictionary*)aResourceDict action:(SEL)inSelector;
- (id)initWithFrame:(NSRect)aFrame imageNamesDictionary:(NSDictionary*)aResourceDict action:(SEL)inSelector;

- (NSImage*)imageForButtonKey:(NSString*)inString;
- (NSString*)imageNameForButtonKey:(NSString*)inString;
- (void)setImage:(NSImage*)inImageName forButtonKey:(NSString*)inString;
- (void)setImageNamed:(NSString*)inImageName forButtonKey:(NSString*)inString;

- (BOOL)isPointInButtonImage:(NSPoint)aPoint;
- (void)setButtonImages:(NSDictionary*)inDict; // accepts [NSNull null] to clear existing image for a key
- (void)setButtonImageNames:(NSDictionary*)inDict; // accepts @"" to clear exiting image name for a key

@end
