#import <Cocoa/Cocoa.h>

typedef enum 
{
	PCTriangleAlignmentNatural,
	PCTriangleAlignmentStart,
	PCTriangleAlignmentCenter,
	PCTriangleAlignmentEnd
} PCTriangleAlignment;

@interface NSBezierPath (PCBubbles)

+ (NSBezierPath*)pc_bubbleWithRect:(NSRect)aRect cornerRadius:(CGFloat)cornerRadius lineWidth:(CGFloat)lineWidth edge:(NSRectEdge)edge triangleDistance:(CGFloat)distance alignment:(PCTriangleAlignment)alignment;
+ (NSBezierPath*)pc_topBubbleWithRect:(NSRect)aRect cornerRadius:(CGFloat)cornerRadius lineWidth:(CGFloat)lineWidth inset:(CGFloat)inset triangleDistance:(CGFloat)distance alignment:(PCTriangleAlignment)alignment;


// pseudo-private
+ (NSBezierPath*)pc_bottomBubbleWithRect:(NSRect)aRect cornerRadius:(CGFloat)cornerRadius lineWidth:(CGFloat)lineWidth triangleDistance:(CGFloat)distance alignment:(PCTriangleAlignment)alignment;
+ (NSBezierPath*)pc_leftBubbleWithRect:(NSRect)aRect cornerRadius:(CGFloat)cornerRadius lineWidth:(CGFloat)lineWidth triangleDistance:(CGFloat)distance alignment:(PCTriangleAlignment)alignment;
+ (NSBezierPath*)pc_rightBubbleWithRect:(NSRect)aRect cornerRadius:(CGFloat)cornerRadius lineWidth:(CGFloat)lineWidth triangleDistance:(CGFloat)distance alignment:(PCTriangleAlignment)alignment;
+ (NSBezierPath*)pc_topBubbleWithRect:(NSRect)aRect cornerRadius:(CGFloat)cornerRadius lineWidth:(CGFloat)lineWidth triangleDistance:(CGFloat)distance alignment:(PCTriangleAlignment)alignment;

@end
