//
//  NSBezierPath-Gradient.h
//  Transmit
//
//  Created by Wade Cosgrove on 4/9/09.
//  Copyright 2009 Panic, Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface NSBezierPath (Gradient)

// allows the gradient to be a sub-rect of the path's bounds. Useful for rounded rectangles that lie on half pixel bounderies.
- (void)strokeGradient:(NSGradient*)gradient inPathRect:(NSRect)rect angle:(CGFloat)angle;

// stokes the path of the bezier path using the bounds as the gradient rect
- (void)strokeGradient:(NSGradient*)gradient angle:(CGFloat)angle;

// the same as NSGradient drawInBezierPath, but opposite
- (void)fillGradient:(NSGradient*)gradient angle:(CGFloat)angle;

@end
