/*
 *  NSColor-Additions.h
 *
 *  Requires Mac OS X 10.4 or higher
 *
 *	Provides a category for converting an NSColor into a CGColor.
 *
 *	-------------------------------------------------------------------
 *
 *
 */


#import <Cocoa/Cocoa.h>
#import <Carbon/Carbon.h>

@interface NSColor (PCAdditions)

- (NSColor*)pc_adjustBrightness:(CGFloat)brightnessDelta minimum:(CGFloat)minimum;
- (NSColor*)pc_adjustBrightness:(CGFloat)brightnessDelta;
- (CGColorRef)pc_CGColor;
- (NSColor*)pc_graphiteFromAqua;
+ (NSControlTint)pc_currentControlTint;
+ (NSColor*)pc_colorWithCGColor:(CGColorRef)colorRef;
+ (NSColor*)pc_colorWithThemeBrush:(ThemeBrush)themeBrush;
+ (NSColor*)pc_colorWithThemeTextColor:(ThemeTextColor)themeTextColor;

@end
