#import <Foundation/Foundation.h>
#import <sys/time.h>


#define kNanosecondsPerSecond 1000000000.0

@interface NSDate (PCConversions)

+ (NSDate*)pc_dateWithTimespec:(struct timespec)t;
+ (NSDate*)pc_dateWithUTCDateTime:(UTCDateTime)u;
- (struct timespec)pc_timespec;

// <http://mikeash.com/?page=pyblog/friday-qa-2009-11-13-dangerous-cocoa-calls.html>
+ (uint64_t)pc_nanoseconds;
+ (NSTimeInterval)pc_timeIntervalSinceFixedReferenceDate;

@end // NSDate (PCConversions)


// parses date representations as defined by <http://www.ietf.org/rfc/rfc2616.txt>
@interface PCRFC2616DateFormatter : NSDateFormatter
{
@private
	NSDateFormatter* iRFC850Formatter;
	NSDateFormatter* iAsctimeFormatter;
}

+ (PCRFC2616DateFormatter*)defaultFormatter;

@end
