#import <Foundation/Foundation.h>


@interface NSFileManager (PCAdditions)

// The default manager is not safe to simultaneously access from multiple threads; this method instantiates a new instance to avoid such contention (requires 10.5 or later).
+ (NSFileManager*)threadSafeManager;

- (BOOL)pc_itemAtPath:(NSString*)lhs isOnSameVolumeAsItemAtPath:(NSString*)rhs;

- (BOOL)pc_directoryExistsAtPath:(NSString*)path;
- (NSString*)pc_MIMETypeForFilename:(NSString*)filename;

- (BOOL)pc_quarantineItemAtPath:(NSString*)path quaratineType:(NSString*)quarantineType url:(NSURL*)dataURL error:(NSError**)error;
- (BOOL)pc_dequaratineItemAtPath:(NSString*)path error:(NSError**)error;

@end


@interface NSFileManager (PCFolders)

// supported folder types are in Folders.h
- (NSString*)pc_findFolderWithType:(OSType)folderType; // kUserDomain, create if nonexistant
- (NSString*)pc_findFolderWithType:(OSType)folderType inDomain:(OSType)domain; // create if nonexistant
- (NSString*)pc_findFolderWithType:(OSType)folderType inDomain:(OSType)domain creating:(BOOL)creating; // returns nil if creating == NO and folder does not exist

- (NSString*)pc_applicationSupportFolder; // creates "Library/Application Support/<app name>"
- (NSString*)pc_applicationSupportFolderForBundle:(NSBundle*)bundle; // creates "Library/Application Support/<bundle app name>"

- (NSString*)pc_temporaryItemsFolderCreate:(BOOL)flag; // "Library/Caches/TemporaryItems/<app name>"
- (NSString*)pc_chewableItemsFolderCreate:(BOOL)flag; // "Library/Caches/Cleanup At Startup/<app name>"
- (NSString*)pc_cachesFolderCreate:(BOOL)flag; //"Library/Caches/<app name>"

- (NSString*)pc_applicationSupportSubFolder:(NSString*)folderName; // creates "Library/Application Support/<app name>/<folderName>"
- (NSString*)pc_applicationSupportSubFolder:(NSString*)folderName attributes:(NSDictionary*)attributes; // creates "Library/Application Support/<app name>/<folderName>" with attributes
- (NSString*)pc_applicationSupportSubFolder:(NSString*)folderName attributes:(NSDictionary*)attributes bundle:(NSBundle*)bundle; // creates "Library/Application Support/<bundle app name>/<folderName>" with attributes

@end
