//
//  NSObject-PerformSelector.h
//  PanicCore
//
//  Created by Ian Cely on 7/29/08.
//  Copyright 2008 Panic Inc.. All rights reserved.
//

#import <Foundation/Foundation.h>

#if TARGET_OS_IPHONE
#import <CoreGraphics/CoreGraphics.h>
#endif

@interface NSObject (PCPerformSelector)

// someArgs may be nil for no arguments, otherwise someArgs are set as arguments
// to selector in order. Use [NSNull null] to pass nil as an argument.
- (void)pc_performSelectorOnMainThread:(SEL)selector withArguments:(NSArray*)someArgs waitUntilDone:(BOOL)shouldWait;
- (void)pc_performSelectorOnMainThread:(SEL)selector withArguments:(NSArray*)someArgs waitUntilDone:(BOOL)shouldWait modes:(NSArray*)someModes;
- (id)pc_performSelector:(SEL)selector withArguments:(NSArray*)someArgs;

- (void)pc_performOptionalSelector:(SEL)selector;
- (NSInteger)pc_performOptionalSelectorWithIntegerReturn:(SEL)selector;
- (CGFloat)pc_performOptionalSelectorWithCGFloatReturn:(SEL)selector;
- (NSObject*)pc_performOptionalSelectorWithObjectReturn:(SEL)selector withObject:(NSObject*)object;
- (BOOL)pc_performOptionalSelectorWithBOOLReturn:(SEL)selector;
- (void)pc_performOptionalSelector:(SEL)selector withInteger:(NSInteger)integer;
- (void)pc_performOptionalSelector:(SEL)selector withCGFloat:(CGFloat)afloat;
- (void)pc_performOptionalSelector:(SEL)selector withBOOL:(BOOL)boolArg;
- (void)pc_performOptionalSelector:(SEL)selector withObject:(NSObject*)object;

@end
