#import <Foundation/Foundation.h>


// <http://developer.apple.com/qa/qa2004/qa1159.html>
#define kFinderCollateOptions \
	(kUCCollateComposeInsensitiveMask | kUCCollateWidthInsensitiveMask | kUCCollateCaseInsensitiveMask | kUCCollateDigitsOverrideMask | kUCCollateDigitsAsNumberMask | kUCCollatePunctuationSignificantMask)

@interface NSString (PCCollation)

// compare both strings like Finder does
- (NSComparisonResult)pc_localizedStandardCompare:(NSString*)other;

- (NSComparisonResult)pc_versionCompare:(NSString*)other;

// returns an array of UCCollationValue values
- (NSData*)pc_collationKeyForCollator:(CollatorRef)collator;

+ (NSComparisonResult)pc_compareCollationKey:(NSData*)key1 withCollationKey:(NSData*)key2;

@end

@interface NSData (PCCollation)

- (NSComparisonResult)pc_compareWithCollationKey:(NSData*)other;

@end

// these methods implement HFS+ string operations, which are probably not what you want
@interface NSString (PCHFSExtended)

// HFS+ equivalent of decomposedStringWithCanonicalMapping (eg: decomposing {0xF900} will not result in {0x8C48})
- (NSString*)pc_decomposedStringWithHFSExtendedMapping;

// performs nonlocalized, case insensitive comparison of both strings after calling decomposedStringWithHFSExtendedMapping on each
- (BOOL)pc_isEqualToHFSExtendedString:(NSString*)other;

// <http://developer.apple.com/technotes/tn/tn1150.html#UnicodeSubtleties>
- (NSString*)pc_stringByHFSExtendedFolding;

@end
