#import <Foundation/Foundation.h>


// this can be used to reference the thread created by pc_detachNewThreadSelector:toTarget:withObject:name: before it exists
@interface PCThreadFuture : NSObject
{
	NSCondition* iLock;
	NSThread* iThread;
	NSString* iName;
}

// will block until thread begins execution
- (NSThread*)thread;

// call this at any time to set thread name using pc_setName:, will not block if thread has begun execution, in which case will set most recent name upon execution
- (void)setName:(NSString*)name;

@end


@interface NSThread (PCAdditions)

- (void)pc_setName:(NSString*)name; // sets thread name for Xcode and crash reports
- (NSString*)pc_name;

+ (PCThreadFuture*)pc_detachNewThreadSelector:(SEL)selector toTarget:(id)target withObject:(id)object name:(NSString*)name;

@end
